/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.connect.build.Build;
import io.strimzi.api.kafka.model.connect.build.BuildFluent;
import io.strimzi.api.kafka.model.connect.build.DockerOutput;
import io.strimzi.api.kafka.model.connect.build.DockerOutputBuilder;
import io.strimzi.api.kafka.model.connect.build.DockerOutputFluentImpl;
import io.strimzi.api.kafka.model.connect.build.ImageStreamOutput;
import io.strimzi.api.kafka.model.connect.build.ImageStreamOutputBuilder;
import io.strimzi.api.kafka.model.connect.build.ImageStreamOutputFluentImpl;
import io.strimzi.api.kafka.model.connect.build.Output;
import io.strimzi.api.kafka.model.connect.build.Plugin;
import io.strimzi.api.kafka.model.connect.build.PluginBuilder;
import io.strimzi.api.kafka.model.connect.build.PluginFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class BuildFluentImpl<A extends BuildFluent<A>>
extends BaseFluent<A>
implements BuildFluent<A> {
    private VisitableBuilder<? extends Output, ?> output;
    private List<PluginBuilder> plugins;
    private ResourceRequirements resources;

    public BuildFluentImpl() {
    }

    public BuildFluentImpl(Build instance) {
        this.withOutput(instance.getOutput());
        this.withPlugins(instance.getPlugins());
        this.withResources(instance.getResources());
    }

    @Override
    @Deprecated
    public Output getOutput() {
        return this.output != null ? (Output)this.output.build() : null;
    }

    @Override
    public Output buildOutput() {
        return this.output != null ? (Output)this.output.build() : null;
    }

    @Override
    public A withOutput(Output output) {
        if (output instanceof ImageStreamOutput) {
            this.output = new ImageStreamOutputBuilder((ImageStreamOutput)output);
            this._visitables.get((Object)"output").add(this.output);
        }
        if (output instanceof DockerOutput) {
            this.output = new DockerOutputBuilder((DockerOutput)output);
            this._visitables.get((Object)"output").add(this.output);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOutput() {
        return this.output != null;
    }

    @Override
    public A withImageStreamOutput(ImageStreamOutput imageStreamOutput) {
        this._visitables.get((Object)"output").remove(this.output);
        if (imageStreamOutput != null) {
            this.output = new ImageStreamOutputBuilder(imageStreamOutput);
            this._visitables.get((Object)"output").add(this.output);
        }
        return (A)this;
    }

    @Override
    public BuildFluent.ImageStreamOutputNested<A> withNewImageStreamOutput() {
        return new ImageStreamOutputNestedImpl();
    }

    @Override
    public BuildFluent.ImageStreamOutputNested<A> withNewImageStreamOutputLike(ImageStreamOutput item) {
        return new ImageStreamOutputNestedImpl(item);
    }

    @Override
    public A withDockerOutput(DockerOutput dockerOutput) {
        this._visitables.get((Object)"output").remove(this.output);
        if (dockerOutput != null) {
            this.output = new DockerOutputBuilder(dockerOutput);
            this._visitables.get((Object)"output").add(this.output);
        }
        return (A)this;
    }

    @Override
    public BuildFluent.DockerOutputNested<A> withNewDockerOutput() {
        return new DockerOutputNestedImpl();
    }

    @Override
    public BuildFluent.DockerOutputNested<A> withNewDockerOutputLike(DockerOutput item) {
        return new DockerOutputNestedImpl(item);
    }

    @Override
    public A addToPlugins(int index, Plugin item) {
        if (this.plugins == null) {
            this.plugins = new ArrayList<PluginBuilder>();
        }
        PluginBuilder builder = new PluginBuilder(item);
        this._visitables.get((Object)"plugins").add(index >= 0 ? index : this._visitables.get((Object)"plugins").size(), builder);
        this.plugins.add(index >= 0 ? index : this.plugins.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPlugins(int index, Plugin item) {
        if (this.plugins == null) {
            this.plugins = new ArrayList<PluginBuilder>();
        }
        PluginBuilder builder = new PluginBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"plugins").size()) {
            this._visitables.get((Object)"plugins").add(builder);
        } else {
            this._visitables.get((Object)"plugins").set(index, builder);
        }
        if (index < 0 || index >= this.plugins.size()) {
            this.plugins.add(builder);
        } else {
            this.plugins.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPlugins(Plugin ... items) {
        if (this.plugins == null) {
            this.plugins = new ArrayList<PluginBuilder>();
        }
        for (Plugin item : items) {
            PluginBuilder builder = new PluginBuilder(item);
            this._visitables.get((Object)"plugins").add(builder);
            this.plugins.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPlugins(Collection<Plugin> items) {
        if (this.plugins == null) {
            this.plugins = new ArrayList<PluginBuilder>();
        }
        for (Plugin item : items) {
            PluginBuilder builder = new PluginBuilder(item);
            this._visitables.get((Object)"plugins").add(builder);
            this.plugins.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPlugins(Plugin ... items) {
        for (Plugin item : items) {
            PluginBuilder builder = new PluginBuilder(item);
            this._visitables.get((Object)"plugins").remove(builder);
            if (this.plugins == null) continue;
            this.plugins.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPlugins(Collection<Plugin> items) {
        for (Plugin item : items) {
            PluginBuilder builder = new PluginBuilder(item);
            this._visitables.get((Object)"plugins").remove(builder);
            if (this.plugins == null) continue;
            this.plugins.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPlugins(Predicate<PluginBuilder> predicate) {
        if (this.plugins == null) {
            return (A)this;
        }
        Iterator<PluginBuilder> each = this.plugins.iterator();
        List visitables = this._visitables.get((Object)"plugins");
        while (each.hasNext()) {
            PluginBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Plugin> getPlugins() {
        return BuildFluentImpl.build(this.plugins);
    }

    @Override
    public List<Plugin> buildPlugins() {
        return BuildFluentImpl.build(this.plugins);
    }

    @Override
    public Plugin buildPlugin(int index) {
        return this.plugins.get(index).build();
    }

    @Override
    public Plugin buildFirstPlugin() {
        return this.plugins.get(0).build();
    }

    @Override
    public Plugin buildLastPlugin() {
        return this.plugins.get(this.plugins.size() - 1).build();
    }

    @Override
    public Plugin buildMatchingPlugin(Predicate<PluginBuilder> predicate) {
        for (PluginBuilder item : this.plugins) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPlugin(Predicate<PluginBuilder> predicate) {
        for (PluginBuilder item : this.plugins) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPlugins(List<Plugin> plugins) {
        if (this.plugins != null) {
            this._visitables.get((Object)"plugins").removeAll(this.plugins);
        }
        if (plugins != null) {
            this.plugins = new ArrayList<PluginBuilder>();
            for (Plugin item : plugins) {
                this.addToPlugins(item);
            }
        } else {
            this.plugins = null;
        }
        return (A)this;
    }

    @Override
    public A withPlugins(Plugin ... plugins) {
        if (this.plugins != null) {
            this.plugins.clear();
        }
        if (plugins != null) {
            for (Plugin item : plugins) {
                this.addToPlugins(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPlugins() {
        return this.plugins != null && !this.plugins.isEmpty();
    }

    @Override
    public BuildFluent.PluginsNested<A> addNewPlugin() {
        return new PluginsNestedImpl();
    }

    @Override
    public BuildFluent.PluginsNested<A> addNewPluginLike(Plugin item) {
        return new PluginsNestedImpl(-1, item);
    }

    @Override
    public BuildFluent.PluginsNested<A> setNewPluginLike(int index, Plugin item) {
        return new PluginsNestedImpl(index, item);
    }

    @Override
    public BuildFluent.PluginsNested<A> editPlugin(int index) {
        if (this.plugins.size() <= index) {
            throw new RuntimeException("Can't edit plugins. Index exceeds size.");
        }
        return this.setNewPluginLike(index, this.buildPlugin(index));
    }

    @Override
    public BuildFluent.PluginsNested<A> editFirstPlugin() {
        if (this.plugins.size() == 0) {
            throw new RuntimeException("Can't edit first plugins. The list is empty.");
        }
        return this.setNewPluginLike(0, this.buildPlugin(0));
    }

    @Override
    public BuildFluent.PluginsNested<A> editLastPlugin() {
        int index = this.plugins.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last plugins. The list is empty.");
        }
        return this.setNewPluginLike(index, this.buildPlugin(index));
    }

    @Override
    public BuildFluent.PluginsNested<A> editMatchingPlugin(Predicate<PluginBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.plugins.size(); ++i) {
            if (!predicate.test(this.plugins.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching plugins. No match found.");
        }
        return this.setNewPluginLike(index, this.buildPlugin(index));
    }

    @Override
    public ResourceRequirements getResources() {
        return this.resources;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this.resources = resources;
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildFluentImpl that = (BuildFluentImpl)o;
        if (this.output != null ? !this.output.equals(that.output) : that.output != null) {
            return false;
        }
        if (this.plugins != null ? !this.plugins.equals(that.plugins) : that.plugins != null) {
            return false;
        }
        return !(this.resources != null ? !this.resources.equals((Object)that.resources) : that.resources != null);
    }

    public int hashCode() {
        return Objects.hash(this.output, this.plugins, this.resources, super.hashCode());
    }

    public class PluginsNestedImpl<N>
    extends PluginFluentImpl<BuildFluent.PluginsNested<N>>
    implements BuildFluent.PluginsNested<N>,
    Nested<N> {
        private final PluginBuilder builder;
        private final int index;

        PluginsNestedImpl(int index, Plugin item) {
            this.index = index;
            this.builder = new PluginBuilder(this, item);
        }

        PluginsNestedImpl() {
            this.index = -1;
            this.builder = new PluginBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildFluentImpl.this.setToPlugins(this.index, this.builder.build());
        }

        @Override
        public N endPlugin() {
            return this.and();
        }
    }

    public class DockerOutputNestedImpl<N>
    extends DockerOutputFluentImpl<BuildFluent.DockerOutputNested<N>>
    implements BuildFluent.DockerOutputNested<N>,
    Nested<N> {
        private final DockerOutputBuilder builder;

        DockerOutputNestedImpl(DockerOutput item) {
            this.builder = new DockerOutputBuilder(this, item);
        }

        DockerOutputNestedImpl() {
            this.builder = new DockerOutputBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildFluentImpl.this.withOutput(this.builder.build());
        }

        @Override
        public N endDockerOutput() {
            return this.and();
        }
    }

    public class ImageStreamOutputNestedImpl<N>
    extends ImageStreamOutputFluentImpl<BuildFluent.ImageStreamOutputNested<N>>
    implements BuildFluent.ImageStreamOutputNested<N>,
    Nested<N> {
        private final ImageStreamOutputBuilder builder;

        ImageStreamOutputNestedImpl(ImageStreamOutput item) {
            this.builder = new ImageStreamOutputBuilder(this, item);
        }

        ImageStreamOutputNestedImpl() {
            this.builder = new ImageStreamOutputBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildFluentImpl.this.withOutput(this.builder.build());
        }

        @Override
        public N endImageStreamOutput() {
            return this.and();
        }
    }
}

