/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.connect.build.DownloadableArtifact;
import io.strimzi.api.kafka.model.connect.build.DownloadableArtifactFluent;
import java.util.Objects;

public class DownloadableArtifactFluentImpl<A extends DownloadableArtifactFluent<A>>
extends BaseFluent<A>
implements DownloadableArtifactFluent<A> {
    private String url;
    private String sha512sum;

    public DownloadableArtifactFluentImpl() {
    }

    public DownloadableArtifactFluentImpl(DownloadableArtifact instance) {
        this.withUrl(instance.getUrl());
        this.withSha512sum(instance.getSha512sum());
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    @Override
    public Boolean hasUrl() {
        return this.url != null;
    }

    @Override
    @Deprecated
    public A withNewUrl(String original) {
        return this.withUrl(new String(original));
    }

    @Override
    public String getSha512sum() {
        return this.sha512sum;
    }

    @Override
    public A withSha512sum(String sha512sum) {
        this.sha512sum = sha512sum;
        return (A)this;
    }

    @Override
    public Boolean hasSha512sum() {
        return this.sha512sum != null;
    }

    @Override
    @Deprecated
    public A withNewSha512sum(String original) {
        return this.withSha512sum(new String(original));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadableArtifactFluentImpl that = (DownloadableArtifactFluentImpl)o;
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return !(this.sha512sum != null ? !this.sha512sum.equals(that.sha512sum) : that.sha512sum != null);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.sha512sum, super.hashCode());
    }
}

