/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.connect.build.ImageStreamOutput;
import io.strimzi.api.kafka.model.connect.build.ImageStreamOutputFluent;
import io.strimzi.api.kafka.model.connect.build.ImageStreamOutputFluentImpl;
import java.util.Objects;

public class ImageStreamOutputBuilder
extends ImageStreamOutputFluentImpl<ImageStreamOutputBuilder>
implements VisitableBuilder<ImageStreamOutput, ImageStreamOutputBuilder> {
    ImageStreamOutputFluent<?> fluent;
    Boolean validationEnabled;

    public ImageStreamOutputBuilder() {
        this(true);
    }

    public ImageStreamOutputBuilder(Boolean validationEnabled) {
        this(new ImageStreamOutput(), validationEnabled);
    }

    public ImageStreamOutputBuilder(ImageStreamOutputFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageStreamOutputBuilder(ImageStreamOutputFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageStreamOutput(), validationEnabled);
    }

    public ImageStreamOutputBuilder(ImageStreamOutputFluent<?> fluent, ImageStreamOutput instance) {
        this(fluent, instance, true);
    }

    public ImageStreamOutputBuilder(ImageStreamOutputFluent<?> fluent, ImageStreamOutput instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withImage(instance.getImage());
        this.validationEnabled = validationEnabled;
    }

    public ImageStreamOutputBuilder(ImageStreamOutput instance) {
        this(instance, (Boolean)true);
    }

    public ImageStreamOutputBuilder(ImageStreamOutput instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withImage(instance.getImage());
        this.validationEnabled = validationEnabled;
    }

    public ImageStreamOutput build() {
        ImageStreamOutput buildable = new ImageStreamOutput();
        buildable.setImage(this.fluent.getImage());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamOutputBuilder that = (ImageStreamOutputBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

