/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.connect.build.Plugin;
import io.strimzi.api.kafka.model.connect.build.PluginFluent;
import io.strimzi.api.kafka.model.connect.build.PluginFluentImpl;
import java.util.Objects;

public class PluginBuilder
extends PluginFluentImpl<PluginBuilder>
implements VisitableBuilder<Plugin, PluginBuilder> {
    PluginFluent<?> fluent;
    Boolean validationEnabled;

    public PluginBuilder() {
        this(true);
    }

    public PluginBuilder(Boolean validationEnabled) {
        this(new Plugin(), validationEnabled);
    }

    public PluginBuilder(PluginFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PluginBuilder(PluginFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Plugin(), validationEnabled);
    }

    public PluginBuilder(PluginFluent<?> fluent, Plugin instance) {
        this(fluent, instance, true);
    }

    public PluginBuilder(PluginFluent<?> fluent, Plugin instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withArtifacts(instance.getArtifacts());
        this.validationEnabled = validationEnabled;
    }

    public PluginBuilder(Plugin instance) {
        this(instance, (Boolean)true);
    }

    public PluginBuilder(Plugin instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withArtifacts(instance.getArtifacts());
        this.validationEnabled = validationEnabled;
    }

    public Plugin build() {
        Plugin buildable = new Plugin();
        buildable.setName(this.fluent.getName());
        buildable.setArtifacts(this.fluent.getArtifacts());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PluginBuilder that = (PluginBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

