/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener.arraylistener;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthBuilder;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluentImpl;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512FluentImpl;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTls;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTlsFluentImpl;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfiguration;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBuilder;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluentImpl;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent;
import io.strimzi.api.kafka.model.listener.arraylistener.KafkaListenerType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class GenericKafkaListenerFluentImpl<A extends GenericKafkaListenerFluent<A>>
extends BaseFluent<A>
implements GenericKafkaListenerFluent<A> {
    private String name;
    private int port;
    private KafkaListenerType type;
    private boolean tls;
    private VisitableBuilder<? extends KafkaListenerAuthentication, ?> auth;
    private GenericKafkaListenerConfigurationBuilder configuration;
    private List<NetworkPolicyPeer> networkPolicyPeers;

    public GenericKafkaListenerFluentImpl() {
    }

    public GenericKafkaListenerFluentImpl(GenericKafkaListener instance) {
        this.withName(instance.getName());
        this.withPort(instance.getPort());
        this.withType(instance.getType());
        this.withTls(instance.isTls());
        this.withAuth(instance.getAuth());
        this.withConfiguration(instance.getConfiguration());
        this.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String original) {
        return this.withName(new String(original));
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public A withPort(int port) {
        this.port = port;
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return true;
    }

    @Override
    public KafkaListenerType getType() {
        return this.type;
    }

    @Override
    public A withType(KafkaListenerType type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    public boolean isTls() {
        return this.tls;
    }

    @Override
    public A withTls(boolean tls) {
        this.tls = tls;
        return (A)this;
    }

    @Override
    public Boolean hasTls() {
        return true;
    }

    @Override
    @Deprecated
    public KafkaListenerAuthentication getAuth() {
        return this.auth != null ? (KafkaListenerAuthentication)this.auth.build() : null;
    }

    @Override
    public KafkaListenerAuthentication buildAuth() {
        return this.auth != null ? (KafkaListenerAuthentication)this.auth.build() : null;
    }

    @Override
    public A withAuth(KafkaListenerAuthentication auth) {
        this._visitables.get((Object)"auth").remove(this.auth);
        if (auth instanceof KafkaListenerAuthenticationOAuth) {
            this.auth = new KafkaListenerAuthenticationOAuthBuilder((KafkaListenerAuthenticationOAuth)auth);
            this._visitables.get((Object)"auth").add(this.auth);
        }
        if (auth instanceof KafkaListenerAuthenticationTls) {
            this.auth = new KafkaListenerAuthenticationTlsBuilder((KafkaListenerAuthenticationTls)auth);
            this._visitables.get((Object)"auth").add(this.auth);
        }
        if (auth instanceof KafkaListenerAuthenticationScramSha512) {
            this.auth = new KafkaListenerAuthenticationScramSha512Builder((KafkaListenerAuthenticationScramSha512)auth);
            this._visitables.get((Object)"auth").add(this.auth);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuth() {
        return this.auth != null;
    }

    @Override
    public A withKafkaListenerAuthenticationOAuth(KafkaListenerAuthenticationOAuth kafkaListenerAuthenticationOAuth) {
        this._visitables.get((Object)"auth").remove(this.auth);
        if (kafkaListenerAuthenticationOAuth != null) {
            this.auth = new KafkaListenerAuthenticationOAuthBuilder(kafkaListenerAuthenticationOAuth);
            this._visitables.get((Object)"auth").add(this.auth);
        }
        return (A)this;
    }

    @Override
    public GenericKafkaListenerFluent.KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuth() {
        return new KafkaListenerAuthenticationOAuthNestedImpl();
    }

    @Override
    public GenericKafkaListenerFluent.KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuthLike(KafkaListenerAuthenticationOAuth item) {
        return new KafkaListenerAuthenticationOAuthNestedImpl(item);
    }

    @Override
    public A withKafkaListenerAuthenticationTlsAuth(KafkaListenerAuthenticationTls kafkaListenerAuthenticationTlsAuth) {
        this._visitables.get((Object)"auth").remove(this.auth);
        if (kafkaListenerAuthenticationTlsAuth != null) {
            this.auth = new KafkaListenerAuthenticationTlsBuilder(kafkaListenerAuthenticationTlsAuth);
            this._visitables.get((Object)"auth").add(this.auth);
        }
        return (A)this;
    }

    @Override
    public GenericKafkaListenerFluent.KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuth() {
        return new KafkaListenerAuthenticationTlsAuthNestedImpl();
    }

    @Override
    public GenericKafkaListenerFluent.KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuthLike(KafkaListenerAuthenticationTls item) {
        return new KafkaListenerAuthenticationTlsAuthNestedImpl(item);
    }

    @Override
    public A withKafkaListenerAuthenticationScramSha512Auth(KafkaListenerAuthenticationScramSha512 kafkaListenerAuthenticationScramSha512Auth) {
        this._visitables.get((Object)"auth").remove(this.auth);
        if (kafkaListenerAuthenticationScramSha512Auth != null) {
            this.auth = new KafkaListenerAuthenticationScramSha512Builder(kafkaListenerAuthenticationScramSha512Auth);
            this._visitables.get((Object)"auth").add(this.auth);
        }
        return (A)this;
    }

    @Override
    public GenericKafkaListenerFluent.KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512Auth() {
        return new KafkaListenerAuthenticationScramSha512AuthNestedImpl();
    }

    @Override
    public GenericKafkaListenerFluent.KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512AuthLike(KafkaListenerAuthenticationScramSha512 item) {
        return new KafkaListenerAuthenticationScramSha512AuthNestedImpl(item);
    }

    @Override
    @Deprecated
    public GenericKafkaListenerConfiguration getConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    @Override
    public GenericKafkaListenerConfiguration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    @Override
    public A withConfiguration(GenericKafkaListenerConfiguration configuration) {
        this._visitables.get((Object)"configuration").remove(this.configuration);
        if (configuration != null) {
            this.configuration = new GenericKafkaListenerConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfiguration() {
        return this.configuration != null;
    }

    @Override
    public GenericKafkaListenerFluent.ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNestedImpl();
    }

    @Override
    public GenericKafkaListenerFluent.ConfigurationNested<A> withNewConfigurationLike(GenericKafkaListenerConfiguration item) {
        return new ConfigurationNestedImpl(item);
    }

    @Override
    public GenericKafkaListenerFluent.ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(this.getConfiguration());
    }

    @Override
    public GenericKafkaListenerFluent.ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(this.getConfiguration() != null ? this.getConfiguration() : new GenericKafkaListenerConfigurationBuilder().build());
    }

    @Override
    public GenericKafkaListenerFluent.ConfigurationNested<A> editOrNewConfigurationLike(GenericKafkaListenerConfiguration item) {
        return this.withNewConfigurationLike(this.getConfiguration() != null ? this.getConfiguration() : item);
    }

    @Override
    public A addToNetworkPolicyPeers(int index, NetworkPolicyPeer item) {
        if (this.networkPolicyPeers == null) {
            this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();
        }
        this.networkPolicyPeers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNetworkPolicyPeers(int index, NetworkPolicyPeer item) {
        if (this.networkPolicyPeers == null) {
            this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();
        }
        this.networkPolicyPeers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNetworkPolicyPeers(NetworkPolicyPeer ... items) {
        if (this.networkPolicyPeers == null) {
            this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();
        }
        for (NetworkPolicyPeer item : items) {
            this.networkPolicyPeers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNetworkPolicyPeers(Collection<NetworkPolicyPeer> items) {
        if (this.networkPolicyPeers == null) {
            this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();
        }
        for (NetworkPolicyPeer item : items) {
            this.networkPolicyPeers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNetworkPolicyPeers(NetworkPolicyPeer ... items) {
        for (NetworkPolicyPeer item : items) {
            if (this.networkPolicyPeers == null) continue;
            this.networkPolicyPeers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNetworkPolicyPeers(Collection<NetworkPolicyPeer> items) {
        for (NetworkPolicyPeer item : items) {
            if (this.networkPolicyPeers == null) continue;
            this.networkPolicyPeers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<NetworkPolicyPeer> getNetworkPolicyPeers() {
        return this.networkPolicyPeers;
    }

    @Override
    public NetworkPolicyPeer getNetworkPolicyPeer(int index) {
        return this.networkPolicyPeers.get(index);
    }

    @Override
    public NetworkPolicyPeer getFirstNetworkPolicyPeer() {
        return this.networkPolicyPeers.get(0);
    }

    @Override
    public NetworkPolicyPeer getLastNetworkPolicyPeer() {
        return this.networkPolicyPeers.get(this.networkPolicyPeers.size() - 1);
    }

    @Override
    public NetworkPolicyPeer getMatchingNetworkPolicyPeer(Predicate<NetworkPolicyPeer> predicate) {
        for (NetworkPolicyPeer item : this.networkPolicyPeers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNetworkPolicyPeer(Predicate<NetworkPolicyPeer> predicate) {
        for (NetworkPolicyPeer item : this.networkPolicyPeers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNetworkPolicyPeers(List<NetworkPolicyPeer> networkPolicyPeers) {
        if (this.networkPolicyPeers != null) {
            this._visitables.get((Object)"networkPolicyPeers").removeAll(this.networkPolicyPeers);
        }
        if (networkPolicyPeers != null) {
            this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();
            for (NetworkPolicyPeer item : networkPolicyPeers) {
                this.addToNetworkPolicyPeers(item);
            }
        } else {
            this.networkPolicyPeers = null;
        }
        return (A)this;
    }

    @Override
    public A withNetworkPolicyPeers(NetworkPolicyPeer ... networkPolicyPeers) {
        if (this.networkPolicyPeers != null) {
            this.networkPolicyPeers.clear();
        }
        if (networkPolicyPeers != null) {
            for (NetworkPolicyPeer item : networkPolicyPeers) {
                this.addToNetworkPolicyPeers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNetworkPolicyPeers() {
        return this.networkPolicyPeers != null && !this.networkPolicyPeers.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericKafkaListenerFluentImpl that = (GenericKafkaListenerFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.port != that.port) {
            return false;
        }
        if (this.type != null ? !this.type.equals((Object)that.type) : that.type != null) {
            return false;
        }
        if (this.tls != that.tls) {
            return false;
        }
        if (this.auth != null ? !this.auth.equals(that.auth) : that.auth != null) {
            return false;
        }
        if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) {
            return false;
        }
        return !(this.networkPolicyPeers != null ? !this.networkPolicyPeers.equals(that.networkPolicyPeers) : that.networkPolicyPeers != null);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.port, this.type, this.tls, this.auth, this.configuration, this.networkPolicyPeers, super.hashCode()});
    }

    public class ConfigurationNestedImpl<N>
    extends GenericKafkaListenerConfigurationFluentImpl<GenericKafkaListenerFluent.ConfigurationNested<N>>
    implements GenericKafkaListenerFluent.ConfigurationNested<N>,
    Nested<N> {
        private final GenericKafkaListenerConfigurationBuilder builder;

        ConfigurationNestedImpl(GenericKafkaListenerConfiguration item) {
            this.builder = new GenericKafkaListenerConfigurationBuilder(this, item);
        }

        ConfigurationNestedImpl() {
            this.builder = new GenericKafkaListenerConfigurationBuilder(this);
        }

        @Override
        public N and() {
            return (N)GenericKafkaListenerFluentImpl.this.withConfiguration(this.builder.build());
        }

        @Override
        public N endConfiguration() {
            return this.and();
        }
    }

    public class KafkaListenerAuthenticationScramSha512AuthNestedImpl<N>
    extends KafkaListenerAuthenticationScramSha512FluentImpl<GenericKafkaListenerFluent.KafkaListenerAuthenticationScramSha512AuthNested<N>>
    implements GenericKafkaListenerFluent.KafkaListenerAuthenticationScramSha512AuthNested<N>,
    Nested<N> {
        private final KafkaListenerAuthenticationScramSha512Builder builder;

        KafkaListenerAuthenticationScramSha512AuthNestedImpl(KafkaListenerAuthenticationScramSha512 item) {
            this.builder = new KafkaListenerAuthenticationScramSha512Builder(this, item);
        }

        KafkaListenerAuthenticationScramSha512AuthNestedImpl() {
            this.builder = new KafkaListenerAuthenticationScramSha512Builder(this);
        }

        @Override
        public N and() {
            return (N)GenericKafkaListenerFluentImpl.this.withAuth(this.builder.build());
        }

        @Override
        public N endKafkaListenerAuthenticationScramSha512Auth() {
            return this.and();
        }
    }

    public class KafkaListenerAuthenticationTlsAuthNestedImpl<N>
    extends KafkaListenerAuthenticationTlsFluentImpl<GenericKafkaListenerFluent.KafkaListenerAuthenticationTlsAuthNested<N>>
    implements GenericKafkaListenerFluent.KafkaListenerAuthenticationTlsAuthNested<N>,
    Nested<N> {
        private final KafkaListenerAuthenticationTlsBuilder builder;

        KafkaListenerAuthenticationTlsAuthNestedImpl(KafkaListenerAuthenticationTls item) {
            this.builder = new KafkaListenerAuthenticationTlsBuilder(this, item);
        }

        KafkaListenerAuthenticationTlsAuthNestedImpl() {
            this.builder = new KafkaListenerAuthenticationTlsBuilder(this);
        }

        @Override
        public N and() {
            return (N)GenericKafkaListenerFluentImpl.this.withAuth(this.builder.build());
        }

        @Override
        public N endKafkaListenerAuthenticationTlsAuth() {
            return this.and();
        }
    }

    public class KafkaListenerAuthenticationOAuthNestedImpl<N>
    extends KafkaListenerAuthenticationOAuthFluentImpl<GenericKafkaListenerFluent.KafkaListenerAuthenticationOAuthNested<N>>
    implements GenericKafkaListenerFluent.KafkaListenerAuthenticationOAuthNested<N>,
    Nested<N> {
        private final KafkaListenerAuthenticationOAuthBuilder builder;

        KafkaListenerAuthenticationOAuthNestedImpl(KafkaListenerAuthenticationOAuth item) {
            this.builder = new KafkaListenerAuthenticationOAuthBuilder(this, item);
        }

        KafkaListenerAuthenticationOAuthNestedImpl() {
            this.builder = new KafkaListenerAuthenticationOAuthBuilder(this);
        }

        @Override
        public N and() {
            return (N)GenericKafkaListenerFluentImpl.this.withAuth(this.builder.build());
        }

        @Override
        public N endKafkaListenerAuthenticationOAuth() {
            return this.and();
        }
    }
}

