/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.status.ListenerAddress;
import io.strimzi.api.kafka.model.status.ListenerAddressBuilder;
import io.strimzi.api.kafka.model.status.ListenerAddressFluentImpl;
import io.strimzi.api.kafka.model.status.ListenerStatus;
import io.strimzi.api.kafka.model.status.ListenerStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ListenerStatusFluentImpl<A extends ListenerStatusFluent<A>>
extends BaseFluent<A>
implements ListenerStatusFluent<A> {
    private String type;
    private List<ListenerAddressBuilder> addresses;
    private List<String> certificates;

    public ListenerStatusFluentImpl() {
    }

    public ListenerStatusFluentImpl(ListenerStatus instance) {
        this.withType(instance.getType());
        this.withAddresses(instance.getAddresses());
        this.withCertificates(instance.getCertificates());
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    @Deprecated
    public A withNewType(String original) {
        return this.withType(new String(original));
    }

    @Override
    public A addToAddresses(int index, ListenerAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<ListenerAddressBuilder>();
        }
        ListenerAddressBuilder builder = new ListenerAddressBuilder(item);
        this._visitables.get((Object)"addresses").add(index >= 0 ? index : this._visitables.get((Object)"addresses").size(), builder);
        this.addresses.add(index >= 0 ? index : this.addresses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAddresses(int index, ListenerAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<ListenerAddressBuilder>();
        }
        ListenerAddressBuilder builder = new ListenerAddressBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"addresses").size()) {
            this._visitables.get((Object)"addresses").add(builder);
        } else {
            this._visitables.get((Object)"addresses").set(index, builder);
        }
        if (index < 0 || index >= this.addresses.size()) {
            this.addresses.add(builder);
        } else {
            this.addresses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAddresses(ListenerAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<ListenerAddressBuilder>();
        }
        for (ListenerAddress item : items) {
            ListenerAddressBuilder builder = new ListenerAddressBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAddresses(Collection<ListenerAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<ListenerAddressBuilder>();
        }
        for (ListenerAddress item : items) {
            ListenerAddressBuilder builder = new ListenerAddressBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAddresses(ListenerAddress ... items) {
        for (ListenerAddress item : items) {
            ListenerAddressBuilder builder = new ListenerAddressBuilder(item);
            this._visitables.get((Object)"addresses").remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAddresses(Collection<ListenerAddress> items) {
        for (ListenerAddress item : items) {
            ListenerAddressBuilder builder = new ListenerAddressBuilder(item);
            this._visitables.get((Object)"addresses").remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAddresses(Predicate<ListenerAddressBuilder> predicate) {
        if (this.addresses == null) {
            return (A)this;
        }
        Iterator<ListenerAddressBuilder> each = this.addresses.iterator();
        List visitables = this._visitables.get((Object)"addresses");
        while (each.hasNext()) {
            ListenerAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ListenerAddress> getAddresses() {
        return ListenerStatusFluentImpl.build(this.addresses);
    }

    @Override
    public List<ListenerAddress> buildAddresses() {
        return ListenerStatusFluentImpl.build(this.addresses);
    }

    @Override
    public ListenerAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    @Override
    public ListenerAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    @Override
    public ListenerAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    @Override
    public ListenerAddress buildMatchingAddress(Predicate<ListenerAddressBuilder> predicate) {
        for (ListenerAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAddress(Predicate<ListenerAddressBuilder> predicate) {
        for (ListenerAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAddresses(List<ListenerAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get((Object)"addresses").removeAll(this.addresses);
        }
        if (addresses != null) {
            this.addresses = new ArrayList<ListenerAddressBuilder>();
            for (ListenerAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)this;
    }

    @Override
    public A withAddresses(ListenerAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
        }
        if (addresses != null) {
            for (ListenerAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    @Override
    public ListenerStatusFluent.AddressesNested<A> addNewAddress() {
        return new AddressesNestedImpl();
    }

    @Override
    public ListenerStatusFluent.AddressesNested<A> addNewAddressLike(ListenerAddress item) {
        return new AddressesNestedImpl(-1, item);
    }

    @Override
    public ListenerStatusFluent.AddressesNested<A> setNewAddressLike(int index, ListenerAddress item) {
        return new AddressesNestedImpl(index, item);
    }

    @Override
    public ListenerStatusFluent.AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public ListenerStatusFluent.AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    @Override
    public ListenerStatusFluent.AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public ListenerStatusFluent.AddressesNested<A> editMatchingAddress(Predicate<ListenerAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public A addToCertificates(int index, String item) {
        if (this.certificates == null) {
            this.certificates = new ArrayList<String>();
        }
        this.certificates.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCertificates(int index, String item) {
        if (this.certificates == null) {
            this.certificates = new ArrayList<String>();
        }
        this.certificates.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCertificates(String ... items) {
        if (this.certificates == null) {
            this.certificates = new ArrayList<String>();
        }
        for (String item : items) {
            this.certificates.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCertificates(Collection<String> items) {
        if (this.certificates == null) {
            this.certificates = new ArrayList<String>();
        }
        for (String item : items) {
            this.certificates.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCertificates(String ... items) {
        for (String item : items) {
            if (this.certificates == null) continue;
            this.certificates.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCertificates(Collection<String> items) {
        for (String item : items) {
            if (this.certificates == null) continue;
            this.certificates.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCertificates() {
        return this.certificates;
    }

    @Override
    public String getCertificate(int index) {
        return this.certificates.get(index);
    }

    @Override
    public String getFirstCertificate() {
        return this.certificates.get(0);
    }

    @Override
    public String getLastCertificate() {
        return this.certificates.get(this.certificates.size() - 1);
    }

    @Override
    public String getMatchingCertificate(Predicate<String> predicate) {
        for (String item : this.certificates) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCertificate(Predicate<String> predicate) {
        for (String item : this.certificates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCertificates(List<String> certificates) {
        if (this.certificates != null) {
            this._visitables.get((Object)"certificates").removeAll(this.certificates);
        }
        if (certificates != null) {
            this.certificates = new ArrayList<String>();
            for (String item : certificates) {
                this.addToCertificates(item);
            }
        } else {
            this.certificates = null;
        }
        return (A)this;
    }

    @Override
    public A withCertificates(String ... certificates) {
        if (this.certificates != null) {
            this.certificates.clear();
        }
        if (certificates != null) {
            for (String item : certificates) {
                this.addToCertificates(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCertificates() {
        return this.certificates != null && !this.certificates.isEmpty();
    }

    @Override
    public A addNewCertificate(String original) {
        return this.addToCertificates(new String(original));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListenerStatusFluentImpl that = (ListenerStatusFluentImpl)o;
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        return !(this.certificates != null ? !this.certificates.equals(that.certificates) : that.certificates != null);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.addresses, this.certificates, super.hashCode());
    }

    public class AddressesNestedImpl<N>
    extends ListenerAddressFluentImpl<ListenerStatusFluent.AddressesNested<N>>
    implements ListenerStatusFluent.AddressesNested<N>,
    Nested<N> {
        private final ListenerAddressBuilder builder;
        private final int index;

        AddressesNestedImpl(int index, ListenerAddress item) {
            this.index = index;
            this.builder = new ListenerAddressBuilder(this, item);
        }

        AddressesNestedImpl() {
            this.index = -1;
            this.builder = new ListenerAddressBuilder(this);
        }

        @Override
        public N and() {
            return (N)ListenerStatusFluentImpl.this.setToAddresses(this.index, this.builder.build());
        }

        @Override
        public N endAddress() {
            return this.and();
        }
    }
}

