/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate;
import io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent;
import io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl;
import java.util.Objects;

public class ZookeeperClusterTemplateBuilder
extends ZookeeperClusterTemplateFluentImpl<ZookeeperClusterTemplateBuilder>
implements VisitableBuilder<ZookeeperClusterTemplate, ZookeeperClusterTemplateBuilder> {
    ZookeeperClusterTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public ZookeeperClusterTemplateBuilder() {
        this(true);
    }

    public ZookeeperClusterTemplateBuilder(Boolean validationEnabled) {
        this(new ZookeeperClusterTemplate(), validationEnabled);
    }

    public ZookeeperClusterTemplateBuilder(ZookeeperClusterTemplateFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ZookeeperClusterTemplateBuilder(ZookeeperClusterTemplateFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ZookeeperClusterTemplate(), validationEnabled);
    }

    public ZookeeperClusterTemplateBuilder(ZookeeperClusterTemplateFluent<?> fluent, ZookeeperClusterTemplate instance) {
        this(fluent, instance, true);
    }

    public ZookeeperClusterTemplateBuilder(ZookeeperClusterTemplateFluent<?> fluent, ZookeeperClusterTemplate instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withStatefulset(instance.getStatefulset());
        fluent.withPod(instance.getPod());
        fluent.withClientService(instance.getClientService());
        fluent.withNodesService(instance.getNodesService());
        fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        fluent.withZookeeperContainer(instance.getZookeeperContainer());
        fluent.withServiceAccount(instance.getServiceAccount());
        this.validationEnabled = validationEnabled;
    }

    public ZookeeperClusterTemplateBuilder(ZookeeperClusterTemplate instance) {
        this(instance, (Boolean)true);
    }

    public ZookeeperClusterTemplateBuilder(ZookeeperClusterTemplate instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withStatefulset(instance.getStatefulset());
        this.withPod(instance.getPod());
        this.withClientService(instance.getClientService());
        this.withNodesService(instance.getNodesService());
        this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        this.withZookeeperContainer(instance.getZookeeperContainer());
        this.withServiceAccount(instance.getServiceAccount());
        this.validationEnabled = validationEnabled;
    }

    public ZookeeperClusterTemplate build() {
        ZookeeperClusterTemplate buildable = new ZookeeperClusterTemplate();
        buildable.setStatefulset(this.fluent.getStatefulset());
        buildable.setPod(this.fluent.getPod());
        buildable.setClientService(this.fluent.getClientService());
        buildable.setNodesService(this.fluent.getNodesService());
        buildable.setPersistentVolumeClaim(this.fluent.getPersistentVolumeClaim());
        buildable.setPodDisruptionBudget(this.fluent.getPodDisruptionBudget());
        buildable.setZookeeperContainer(this.fluent.getZookeeperContainer());
        buildable.setServiceAccount(this.fluent.getServiceAccount());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ZookeeperClusterTemplateBuilder that = (ZookeeperClusterTemplateBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

