/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.strimzi.api.kafka.model.Quantities;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Pattern;
import io.strimzi.crdgenerator.annotations.Type;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CpuMemory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String memory;
    private String milliCpu;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @JsonIgnore
    public long memoryAsLong() {
        return this.memory == null ? 0L : Quantities.parseMemory(this.memory);
    }

    public void memoryAsLong(long memory) {
        this.memory = Quantities.formatMemory(memory);
    }

    @Description(value="Memory")
    @Pattern(value="[0-9]+([kKmMgGtTpPeE]i?)?$")
    @Type(value="string")
    @JsonProperty(value="memory")
    public String getMemory() {
        return this.memory;
    }

    public void setMemory(String mem) {
        this.memory = mem;
    }

    @JsonIgnore
    public int milliCpuAsInt() {
        return this.milliCpu == null ? 0 : Quantities.parseCpuAsMilliCpus(this.milliCpu);
    }

    public void milliCpuAsInt(int milliCpu) {
        this.milliCpu = Quantities.formatMilliCpu(milliCpu);
    }

    @Description(value="CPU")
    @JsonProperty(value="cpu")
    @Type(value="string")
    @Pattern(value="[0-9]+m?$")
    public String getMilliCpu() {
        return this.milliCpu;
    }

    public void setMilliCpu(String milliCpu) {
        this.milliCpu = milliCpu;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }
}

