/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.Logging;
import io.strimzi.api.kafka.model.Resources;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Minimum;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"watchedNamespace", "image", "reconciliationIntervalSeconds", "zookeeperSessionTimeoutSeconds", "resources", "logging"})
public class EntityUserOperatorSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_IMAGE = System.getenv().getOrDefault("STRIMZI_DEFAULT_USER_OPERATOR_IMAGE", "strimzi/user-operator:latest");
    public static final int DEFAULT_HEALTHCHECK_DELAY = 10;
    public static final int DEFAULT_HEALTHCHECK_TIMEOUT = 5;
    public static final int DEFAULT_ZOOKEEPER_PORT = 2181;
    public static final long DEFAULT_FULL_RECONCILIATION_INTERVAL_SECONDS = 120L;
    public static final long DEFAULT_ZOOKEEPER_SESSION_TIMEOUT_SECONDS = 6L;
    private String watchedNamespace;
    private String image = DEFAULT_IMAGE;
    private long reconciliationIntervalSeconds = 120L;
    private long zookeeperSessionTimeoutSeconds = 6L;
    private Resources resources;
    private Logging logging;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="The namespace the User Operator should watch.")
    public String getWatchedNamespace() {
        return this.watchedNamespace;
    }

    public void setWatchedNamespace(String watchedNamespace) {
        this.watchedNamespace = watchedNamespace;
    }

    @Description(value="The image to use for the User Operator")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @Description(value="Interval between periodic reconciliations.")
    @Minimum(value=0)
    public long getReconciliationIntervalSeconds() {
        return this.reconciliationIntervalSeconds;
    }

    public void setReconciliationIntervalSeconds(long reconciliationIntervalSeconds) {
        this.reconciliationIntervalSeconds = reconciliationIntervalSeconds;
    }

    @Description(value="Timeout for the Zookeeper session")
    @Minimum(value=0)
    public long getZookeeperSessionTimeoutSeconds() {
        return this.zookeeperSessionTimeoutSeconds;
    }

    public void setZookeeperSessionTimeoutSeconds(long zookeeperSessionTimeoutSeconds) {
        this.zookeeperSessionTimeoutSeconds = zookeeperSessionTimeoutSeconds;
    }

    @Description(value="Resource constraints (limits and requests).")
    public Resources getResources() {
        return this.resources;
    }

    @Description(value="Resource constraints (limits and requests).")
    public void setResources(Resources resources) {
        this.resources = resources;
    }

    @Description(value="Logging configuration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Logging getLogging() {
        return this.logging;
    }

    public void setLogging(Logging logging) {
        this.logging = logging;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }
}

