/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.Toleration;
import io.strimzi.api.kafka.model.EphemeralStorage;
import io.strimzi.api.kafka.model.EphemeralStorageBuilder;
import io.strimzi.api.kafka.model.EphemeralStorageFluentImpl;
import io.strimzi.api.kafka.model.ExternalLogging;
import io.strimzi.api.kafka.model.ExternalLoggingBuilder;
import io.strimzi.api.kafka.model.ExternalLoggingFluentImpl;
import io.strimzi.api.kafka.model.InlineLogging;
import io.strimzi.api.kafka.model.InlineLoggingBuilder;
import io.strimzi.api.kafka.model.InlineLoggingFluentImpl;
import io.strimzi.api.kafka.model.JvmOptions;
import io.strimzi.api.kafka.model.JvmOptionsBuilder;
import io.strimzi.api.kafka.model.JvmOptionsFluentImpl;
import io.strimzi.api.kafka.model.KafkaAuthorization;
import io.strimzi.api.kafka.model.KafkaAuthorizationSimple;
import io.strimzi.api.kafka.model.KafkaAuthorizationSimpleBuilder;
import io.strimzi.api.kafka.model.KafkaAuthorizationSimpleFluentImpl;
import io.strimzi.api.kafka.model.KafkaClusterSpec;
import io.strimzi.api.kafka.model.KafkaClusterSpecFluent;
import io.strimzi.api.kafka.model.KafkaListeners;
import io.strimzi.api.kafka.model.KafkaListenersBuilder;
import io.strimzi.api.kafka.model.KafkaListenersFluentImpl;
import io.strimzi.api.kafka.model.Logging;
import io.strimzi.api.kafka.model.PersistentClaimStorage;
import io.strimzi.api.kafka.model.PersistentClaimStorageBuilder;
import io.strimzi.api.kafka.model.PersistentClaimStorageFluentImpl;
import io.strimzi.api.kafka.model.Probe;
import io.strimzi.api.kafka.model.ProbeBuilder;
import io.strimzi.api.kafka.model.ProbeFluentImpl;
import io.strimzi.api.kafka.model.Rack;
import io.strimzi.api.kafka.model.RackBuilder;
import io.strimzi.api.kafka.model.RackFluentImpl;
import io.strimzi.api.kafka.model.Resources;
import io.strimzi.api.kafka.model.ResourcesBuilder;
import io.strimzi.api.kafka.model.ResourcesFluentImpl;
import io.strimzi.api.kafka.model.Sidecar;
import io.strimzi.api.kafka.model.SidecarBuilder;
import io.strimzi.api.kafka.model.SidecarFluentImpl;
import io.strimzi.api.kafka.model.Storage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class KafkaClusterSpecFluentImpl<A extends KafkaClusterSpecFluent<A>>
extends BaseFluent<A>
implements KafkaClusterSpecFluent<A> {
    private VisitableBuilder<? extends Storage, ?> storage;
    private Map<String, Object> config;
    private String brokerRackInitImage;
    private RackBuilder rack;
    private VisitableBuilder<? extends Logging, ?> logging;
    private SidecarBuilder tlsSidecar;
    private int replicas;
    private String image;
    private ResourcesBuilder resources;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private JvmOptionsBuilder jvmOptions;
    private Map<String, Object> metrics;
    private Affinity affinity;
    private List<Toleration> tolerations;
    private KafkaListenersBuilder listeners;
    private VisitableBuilder<? extends KafkaAuthorization, ?> authorization;

    public KafkaClusterSpecFluentImpl() {
    }

    public KafkaClusterSpecFluentImpl(KafkaClusterSpec instance) {
        this.withStorage(instance.getStorage());
        this.withConfig(instance.getConfig());
        this.withBrokerRackInitImage(instance.getBrokerRackInitImage());
        this.withRack(instance.getRack());
        this.withLogging(instance.getLogging());
        this.withTlsSidecar(instance.getTlsSidecar());
        this.withReplicas(instance.getReplicas());
        this.withImage(instance.getImage());
        this.withResources(instance.getResources());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withJvmOptions(instance.getJvmOptions());
        this.withMetrics(instance.getMetrics());
        this.withAffinity(instance.getAffinity());
        this.withTolerations(instance.getTolerations());
        this.withListeners(instance.getListeners());
        this.withAuthorization(instance.getAuthorization());
    }

    @Override
    @Deprecated
    public Storage getStorage() {
        return this.storage != null ? (Storage)this.storage.build() : null;
    }

    @Override
    public Storage buildStorage() {
        return this.storage != null ? (Storage)this.storage.build() : null;
    }

    @Override
    public A withStorage(Storage storage) {
        if (storage instanceof EphemeralStorage) {
            this.storage = new EphemeralStorageBuilder((EphemeralStorage)storage);
            this._visitables.add(this.storage);
        }
        if (storage instanceof PersistentClaimStorage) {
            this.storage = new PersistentClaimStorageBuilder((PersistentClaimStorage)storage);
            this._visitables.add(this.storage);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStorage() {
        return this.storage != null;
    }

    @Override
    public A withEphemeralStorageStorage(EphemeralStorage ephemeralStorageStorage) {
        this._visitables.remove(this.storage);
        if (ephemeralStorageStorage != null) {
            this.storage = new EphemeralStorageBuilder(ephemeralStorageStorage);
            this._visitables.add(this.storage);
        }
        return (A)this;
    }

    @Override
    public KafkaClusterSpecFluent.EphemeralStorageStorageNested<A> withNewEphemeralStorageStorage() {
        return new EphemeralStorageStorageNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.EphemeralStorageStorageNested<A> withNewEphemeralStorageStorageLike(EphemeralStorage item) {
        return new EphemeralStorageStorageNestedImpl(item);
    }

    @Override
    public A withPersistentClaimStorageStorage(PersistentClaimStorage persistentClaimStorageStorage) {
        this._visitables.remove(this.storage);
        if (persistentClaimStorageStorage != null) {
            this.storage = new PersistentClaimStorageBuilder(persistentClaimStorageStorage);
            this._visitables.add(this.storage);
        }
        return (A)this;
    }

    @Override
    public KafkaClusterSpecFluent.PersistentClaimStorageStorageNested<A> withNewPersistentClaimStorageStorage() {
        return new PersistentClaimStorageStorageNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.PersistentClaimStorageStorageNested<A> withNewPersistentClaimStorageStorageLike(PersistentClaimStorage item) {
        return new PersistentClaimStorageStorageNestedImpl(item);
    }

    @Override
    public A addToConfig(String key, Object value) {
        if (key != null && value != null) {
            this.config.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToConfig(Map<String, Object> map) {
        if (map != null) {
            this.config.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(String key) {
        if (key != null && this.config != null) {
            this.config.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.config == null) continue;
                this.config.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @Override
    public A withConfig(Map<String, Object> config) {
        if (this.config == null) {
            this.config = new LinkedHashMap<String, Object>();
        } else {
            this.config.clear();
        }
        if (config != null) {
            this.config.putAll(config);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfig() {
        return this.config != null;
    }

    @Override
    public String getBrokerRackInitImage() {
        return this.brokerRackInitImage;
    }

    @Override
    public A withBrokerRackInitImage(String brokerRackInitImage) {
        this.brokerRackInitImage = brokerRackInitImage;
        return (A)this;
    }

    @Override
    public Boolean hasBrokerRackInitImage() {
        return this.brokerRackInitImage != null;
    }

    @Override
    @Deprecated
    public Rack getRack() {
        return this.rack != null ? this.rack.build() : null;
    }

    @Override
    public Rack buildRack() {
        return this.rack != null ? this.rack.build() : null;
    }

    @Override
    public A withRack(Rack rack) {
        this._visitables.remove(this.rack);
        if (rack != null) {
            this.rack = new RackBuilder(rack);
            this._visitables.add(this.rack);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRack() {
        return this.rack != null;
    }

    @Override
    public A withNewRack(String topologyKey) {
        return this.withRack(new Rack(topologyKey));
    }

    @Override
    public KafkaClusterSpecFluent.RackNested<A> withNewRack() {
        return new RackNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.RackNested<A> withNewRackLike(Rack item) {
        return new RackNestedImpl(item);
    }

    @Override
    public KafkaClusterSpecFluent.RackNested<A> editRack() {
        return this.withNewRackLike(this.getRack());
    }

    @Override
    public KafkaClusterSpecFluent.RackNested<A> editOrNewRack() {
        return this.withNewRackLike(this.getRack() != null ? this.getRack() : new RackBuilder().build());
    }

    @Override
    public KafkaClusterSpecFluent.RackNested<A> editOrNewRackLike(Rack item) {
        return this.withNewRackLike(this.getRack() != null ? this.getRack() : item);
    }

    @Override
    @Deprecated
    public Logging getLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    @Override
    public Logging buildLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    @Override
    public A withLogging(Logging logging) {
        if (logging instanceof ExternalLogging) {
            this.logging = new ExternalLoggingBuilder((ExternalLogging)logging);
            this._visitables.add(this.logging);
        }
        if (logging instanceof InlineLogging) {
            this.logging = new InlineLoggingBuilder((InlineLogging)logging);
            this._visitables.add(this.logging);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLogging() {
        return this.logging != null;
    }

    @Override
    public A withExternalLoggingLogging(ExternalLogging externalLoggingLogging) {
        this._visitables.remove(this.logging);
        if (externalLoggingLogging != null) {
            this.logging = new ExternalLoggingBuilder(externalLoggingLogging);
            this._visitables.add(this.logging);
        }
        return (A)this;
    }

    @Override
    public KafkaClusterSpecFluent.ExternalLoggingLoggingNested<A> withNewExternalLoggingLogging() {
        return new ExternalLoggingLoggingNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.ExternalLoggingLoggingNested<A> withNewExternalLoggingLoggingLike(ExternalLogging item) {
        return new ExternalLoggingLoggingNestedImpl(item);
    }

    @Override
    public A withInlineLoggingLogging(InlineLogging inlineLoggingLogging) {
        this._visitables.remove(this.logging);
        if (inlineLoggingLogging != null) {
            this.logging = new InlineLoggingBuilder(inlineLoggingLogging);
            this._visitables.add(this.logging);
        }
        return (A)this;
    }

    @Override
    public KafkaClusterSpecFluent.InlineLoggingLoggingNested<A> withNewInlineLoggingLogging() {
        return new InlineLoggingLoggingNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.InlineLoggingLoggingNested<A> withNewInlineLoggingLoggingLike(InlineLogging item) {
        return new InlineLoggingLoggingNestedImpl(item);
    }

    @Override
    @Deprecated
    public Sidecar getTlsSidecar() {
        return this.tlsSidecar != null ? this.tlsSidecar.build() : null;
    }

    @Override
    public Sidecar buildTlsSidecar() {
        return this.tlsSidecar != null ? this.tlsSidecar.build() : null;
    }

    @Override
    public A withTlsSidecar(Sidecar tlsSidecar) {
        this._visitables.remove(this.tlsSidecar);
        if (tlsSidecar != null) {
            this.tlsSidecar = new SidecarBuilder(tlsSidecar);
            this._visitables.add(this.tlsSidecar);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsSidecar() {
        return this.tlsSidecar != null;
    }

    @Override
    public KafkaClusterSpecFluent.TlsSidecarNested<A> withNewTlsSidecar() {
        return new TlsSidecarNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.TlsSidecarNested<A> withNewTlsSidecarLike(Sidecar item) {
        return new TlsSidecarNestedImpl(item);
    }

    @Override
    public KafkaClusterSpecFluent.TlsSidecarNested<A> editTlsSidecar() {
        return this.withNewTlsSidecarLike(this.getTlsSidecar());
    }

    @Override
    public KafkaClusterSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecar() {
        return this.withNewTlsSidecarLike(this.getTlsSidecar() != null ? this.getTlsSidecar() : new SidecarBuilder().build());
    }

    @Override
    public KafkaClusterSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecarLike(Sidecar item) {
        return this.withNewTlsSidecarLike(this.getTlsSidecar() != null ? this.getTlsSidecar() : item);
    }

    @Override
    public int getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(int replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return true;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    @Deprecated
    public Resources getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public Resources buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(Resources resources) {
        this._visitables.remove(this.resources);
        if (resources != null) {
            this.resources = new ResourcesBuilder(resources);
            this._visitables.add(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public KafkaClusterSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.ResourcesNested<A> withNewResourcesLike(Resources item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public KafkaClusterSpecFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public KafkaClusterSpecFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new ResourcesBuilder().build());
    }

    @Override
    public KafkaClusterSpecFluent.ResourcesNested<A> editOrNewResourcesLike(Resources item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    @Override
    @Deprecated
    public Probe getLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.remove(this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.add(this.livenessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    @Override
    public A withNewLivenessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    @Override
    public KafkaClusterSpecFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNestedImpl(item);
    }

    @Override
    public KafkaClusterSpecFluent.LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe());
    }

    @Override
    public KafkaClusterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : new ProbeBuilder().build());
    }

    @Override
    public KafkaClusterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : item);
    }

    @Override
    @Deprecated
    public Probe getReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.remove(this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.add(this.readinessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    @Override
    public A withNewReadinessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    @Override
    public KafkaClusterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNestedImpl(item);
    }

    @Override
    public KafkaClusterSpecFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe());
    }

    @Override
    public KafkaClusterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : new ProbeBuilder().build());
    }

    @Override
    public KafkaClusterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : item);
    }

    @Override
    @Deprecated
    public JvmOptions getJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    @Override
    public JvmOptions buildJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    @Override
    public A withJvmOptions(JvmOptions jvmOptions) {
        this._visitables.remove(this.jvmOptions);
        if (jvmOptions != null) {
            this.jvmOptions = new JvmOptionsBuilder(jvmOptions);
            this._visitables.add(this.jvmOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    @Override
    public KafkaClusterSpecFluent.JvmOptionsNested<A> withNewJvmOptions() {
        return new JvmOptionsNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
        return new JvmOptionsNestedImpl(item);
    }

    @Override
    public KafkaClusterSpecFluent.JvmOptionsNested<A> editJvmOptions() {
        return this.withNewJvmOptionsLike(this.getJvmOptions());
    }

    @Override
    public KafkaClusterSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions() {
        return this.withNewJvmOptionsLike(this.getJvmOptions() != null ? this.getJvmOptions() : new JvmOptionsBuilder().build());
    }

    @Override
    public KafkaClusterSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
        return this.withNewJvmOptionsLike(this.getJvmOptions() != null ? this.getJvmOptions() : item);
    }

    @Override
    public A addToMetrics(String key, Object value) {
        if (key != null && value != null) {
            this.metrics.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToMetrics(Map<String, Object> map) {
        if (map != null) {
            this.metrics.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetrics(String key) {
        if (key != null && this.metrics != null) {
            this.metrics.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetrics(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.metrics == null) continue;
                this.metrics.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getMetrics() {
        return this.metrics;
    }

    @Override
    public A withMetrics(Map<String, Object> metrics) {
        if (this.metrics == null) {
            this.metrics = new LinkedHashMap<String, Object>();
        } else {
            this.metrics.clear();
        }
        if (metrics != null) {
            this.metrics.putAll(metrics);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetrics() {
        return this.metrics != null;
    }

    @Override
    public Affinity getAffinity() {
        return this.affinity;
    }

    @Override
    public A withAffinity(Affinity affinity) {
        this.affinity = affinity;
        return (A)this;
    }

    @Override
    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    @Override
    public A addToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTolerations(int index, Toleration item) {
        this.tolerations.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTolerations(Toleration ... items) {
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTolerations(Toleration ... items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    @Override
    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    @Override
    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    @Override
    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    @Override
    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withTolerations(List<Toleration> tolerations) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        } else {
            this._visitables.removeAll(this.tolerations);
            this.tolerations.clear();
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withTolerations(Toleration ... tolerations) {
        this.tolerations.clear();
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    @Override
    @Deprecated
    public KafkaListeners getListeners() {
        return this.listeners != null ? this.listeners.build() : null;
    }

    @Override
    public KafkaListeners buildListeners() {
        return this.listeners != null ? this.listeners.build() : null;
    }

    @Override
    public A withListeners(KafkaListeners listeners) {
        this._visitables.remove(this.listeners);
        if (listeners != null) {
            this.listeners = new KafkaListenersBuilder(listeners);
            this._visitables.add(this.listeners);
        }
        return (A)this;
    }

    @Override
    public Boolean hasListeners() {
        return this.listeners != null;
    }

    @Override
    public KafkaClusterSpecFluent.ListenersNested<A> withNewListeners() {
        return new ListenersNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.ListenersNested<A> withNewListenersLike(KafkaListeners item) {
        return new ListenersNestedImpl(item);
    }

    @Override
    public KafkaClusterSpecFluent.ListenersNested<A> editListeners() {
        return this.withNewListenersLike(this.getListeners());
    }

    @Override
    public KafkaClusterSpecFluent.ListenersNested<A> editOrNewListeners() {
        return this.withNewListenersLike(this.getListeners() != null ? this.getListeners() : new KafkaListenersBuilder().build());
    }

    @Override
    public KafkaClusterSpecFluent.ListenersNested<A> editOrNewListenersLike(KafkaListeners item) {
        return this.withNewListenersLike(this.getListeners() != null ? this.getListeners() : item);
    }

    @Override
    @Deprecated
    public KafkaAuthorization getAuthorization() {
        return this.authorization != null ? (KafkaAuthorization)this.authorization.build() : null;
    }

    @Override
    public KafkaAuthorization buildAuthorization() {
        return this.authorization != null ? (KafkaAuthorization)this.authorization.build() : null;
    }

    @Override
    public A withAuthorization(KafkaAuthorization authorization) {
        if (authorization instanceof KafkaAuthorizationSimple) {
            this.authorization = new KafkaAuthorizationSimpleBuilder((KafkaAuthorizationSimple)authorization);
            this._visitables.add(this.authorization);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuthorization() {
        return this.authorization != null;
    }

    @Override
    public A withKafkaAuthorizationSimpleAuthorization(KafkaAuthorizationSimple kafkaAuthorizationSimpleAuthorization) {
        this._visitables.remove(this.authorization);
        if (kafkaAuthorizationSimpleAuthorization != null) {
            this.authorization = new KafkaAuthorizationSimpleBuilder(kafkaAuthorizationSimpleAuthorization);
            this._visitables.add(this.authorization);
        }
        return (A)this;
    }

    @Override
    public KafkaClusterSpecFluent.KafkaAuthorizationSimpleAuthorizationNested<A> withNewKafkaAuthorizationSimpleAuthorization() {
        return new KafkaAuthorizationSimpleAuthorizationNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.KafkaAuthorizationSimpleAuthorizationNested<A> withNewKafkaAuthorizationSimpleAuthorizationLike(KafkaAuthorizationSimple item) {
        return new KafkaAuthorizationSimpleAuthorizationNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaClusterSpecFluentImpl that = (KafkaClusterSpecFluentImpl)o;
        if (this.storage != null ? !this.storage.equals(that.storage) : that.storage != null) {
            return false;
        }
        if (this.config != null ? !this.config.equals(that.config) : that.config != null) {
            return false;
        }
        if (this.brokerRackInitImage != null ? !this.brokerRackInitImage.equals(that.brokerRackInitImage) : that.brokerRackInitImage != null) {
            return false;
        }
        if (this.rack != null ? !this.rack.equals(that.rack) : that.rack != null) {
            return false;
        }
        if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) {
            return false;
        }
        if (this.tlsSidecar != null ? !this.tlsSidecar.equals(that.tlsSidecar) : that.tlsSidecar != null) {
            return false;
        }
        if (this.replicas != that.replicas) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.livenessProbe != null ? !this.livenessProbe.equals(that.livenessProbe) : that.livenessProbe != null) {
            return false;
        }
        if (this.readinessProbe != null ? !this.readinessProbe.equals(that.readinessProbe) : that.readinessProbe != null) {
            return false;
        }
        if (this.jvmOptions != null ? !this.jvmOptions.equals(that.jvmOptions) : that.jvmOptions != null) {
            return false;
        }
        if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) {
            return false;
        }
        if (this.affinity != null ? !this.affinity.equals((Object)that.affinity) : that.affinity != null) {
            return false;
        }
        if (this.tolerations != null ? !this.tolerations.equals(that.tolerations) : that.tolerations != null) {
            return false;
        }
        if (this.listeners != null ? !this.listeners.equals(that.listeners) : that.listeners != null) {
            return false;
        }
        return !(this.authorization != null ? !this.authorization.equals(that.authorization) : that.authorization != null);
    }

    public class KafkaAuthorizationSimpleAuthorizationNestedImpl<N>
    extends KafkaAuthorizationSimpleFluentImpl<KafkaClusterSpecFluent.KafkaAuthorizationSimpleAuthorizationNested<N>>
    implements KafkaClusterSpecFluent.KafkaAuthorizationSimpleAuthorizationNested<N>,
    Nested<N> {
        private final KafkaAuthorizationSimpleBuilder builder;

        KafkaAuthorizationSimpleAuthorizationNestedImpl(KafkaAuthorizationSimple item) {
            this.builder = new KafkaAuthorizationSimpleBuilder(this, item);
        }

        KafkaAuthorizationSimpleAuthorizationNestedImpl() {
            this.builder = new KafkaAuthorizationSimpleBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withKafkaAuthorizationSimpleAuthorization(this.builder.build());
        }

        @Override
        public N endKafkaAuthorizationSimpleAuthorization() {
            return this.and();
        }
    }

    public class ListenersNestedImpl<N>
    extends KafkaListenersFluentImpl<KafkaClusterSpecFluent.ListenersNested<N>>
    implements KafkaClusterSpecFluent.ListenersNested<N>,
    Nested<N> {
        private final KafkaListenersBuilder builder;

        ListenersNestedImpl(KafkaListeners item) {
            this.builder = new KafkaListenersBuilder(this, item);
        }

        ListenersNestedImpl() {
            this.builder = new KafkaListenersBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withListeners(this.builder.build());
        }

        @Override
        public N endListeners() {
            return this.and();
        }
    }

    public class JvmOptionsNestedImpl<N>
    extends JvmOptionsFluentImpl<KafkaClusterSpecFluent.JvmOptionsNested<N>>
    implements KafkaClusterSpecFluent.JvmOptionsNested<N>,
    Nested<N> {
        private final JvmOptionsBuilder builder;

        JvmOptionsNestedImpl(JvmOptions item) {
            this.builder = new JvmOptionsBuilder(this, item);
        }

        JvmOptionsNestedImpl() {
            this.builder = new JvmOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withJvmOptions(this.builder.build());
        }

        @Override
        public N endJvmOptions() {
            return this.and();
        }
    }

    public class ReadinessProbeNestedImpl<N>
    extends ProbeFluentImpl<KafkaClusterSpecFluent.ReadinessProbeNested<N>>
    implements KafkaClusterSpecFluent.ReadinessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        ReadinessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        ReadinessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withReadinessProbe(this.builder.build());
        }

        @Override
        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class LivenessProbeNestedImpl<N>
    extends ProbeFluentImpl<KafkaClusterSpecFluent.LivenessProbeNested<N>>
    implements KafkaClusterSpecFluent.LivenessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        LivenessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        LivenessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withLivenessProbe(this.builder.build());
        }

        @Override
        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class ResourcesNestedImpl<N>
    extends ResourcesFluentImpl<KafkaClusterSpecFluent.ResourcesNested<N>>
    implements KafkaClusterSpecFluent.ResourcesNested<N>,
    Nested<N> {
        private final ResourcesBuilder builder;

        ResourcesNestedImpl(Resources item) {
            this.builder = new ResourcesBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourcesBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    public class TlsSidecarNestedImpl<N>
    extends SidecarFluentImpl<KafkaClusterSpecFluent.TlsSidecarNested<N>>
    implements KafkaClusterSpecFluent.TlsSidecarNested<N>,
    Nested<N> {
        private final SidecarBuilder builder;

        TlsSidecarNestedImpl(Sidecar item) {
            this.builder = new SidecarBuilder(this, item);
        }

        TlsSidecarNestedImpl() {
            this.builder = new SidecarBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withTlsSidecar(this.builder.build());
        }

        @Override
        public N endTlsSidecar() {
            return this.and();
        }
    }

    public class InlineLoggingLoggingNestedImpl<N>
    extends InlineLoggingFluentImpl<KafkaClusterSpecFluent.InlineLoggingLoggingNested<N>>
    implements KafkaClusterSpecFluent.InlineLoggingLoggingNested<N>,
    Nested<N> {
        private final InlineLoggingBuilder builder;

        InlineLoggingLoggingNestedImpl(InlineLogging item) {
            this.builder = new InlineLoggingBuilder(this, item);
        }

        InlineLoggingLoggingNestedImpl() {
            this.builder = new InlineLoggingBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withInlineLoggingLogging(this.builder.build());
        }

        @Override
        public N endInlineLoggingLogging() {
            return this.and();
        }
    }

    public class ExternalLoggingLoggingNestedImpl<N>
    extends ExternalLoggingFluentImpl<KafkaClusterSpecFluent.ExternalLoggingLoggingNested<N>>
    implements KafkaClusterSpecFluent.ExternalLoggingLoggingNested<N>,
    Nested<N> {
        private final ExternalLoggingBuilder builder;

        ExternalLoggingLoggingNestedImpl(ExternalLogging item) {
            this.builder = new ExternalLoggingBuilder(this, item);
        }

        ExternalLoggingLoggingNestedImpl() {
            this.builder = new ExternalLoggingBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withExternalLoggingLogging(this.builder.build());
        }

        @Override
        public N endExternalLoggingLogging() {
            return this.and();
        }
    }

    public class RackNestedImpl<N>
    extends RackFluentImpl<KafkaClusterSpecFluent.RackNested<N>>
    implements KafkaClusterSpecFluent.RackNested<N>,
    Nested<N> {
        private final RackBuilder builder;

        RackNestedImpl(Rack item) {
            this.builder = new RackBuilder(this, item);
        }

        RackNestedImpl() {
            this.builder = new RackBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withRack(this.builder.build());
        }

        @Override
        public N endRack() {
            return this.and();
        }
    }

    public class PersistentClaimStorageStorageNestedImpl<N>
    extends PersistentClaimStorageFluentImpl<KafkaClusterSpecFluent.PersistentClaimStorageStorageNested<N>>
    implements KafkaClusterSpecFluent.PersistentClaimStorageStorageNested<N>,
    Nested<N> {
        private final PersistentClaimStorageBuilder builder;

        PersistentClaimStorageStorageNestedImpl(PersistentClaimStorage item) {
            this.builder = new PersistentClaimStorageBuilder(this, item);
        }

        PersistentClaimStorageStorageNestedImpl() {
            this.builder = new PersistentClaimStorageBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withPersistentClaimStorageStorage(this.builder.build());
        }

        @Override
        public N endPersistentClaimStorageStorage() {
            return this.and();
        }
    }

    public class EphemeralStorageStorageNestedImpl<N>
    extends EphemeralStorageFluentImpl<KafkaClusterSpecFluent.EphemeralStorageStorageNested<N>>
    implements KafkaClusterSpecFluent.EphemeralStorageStorageNested<N>,
    Nested<N> {
        private final EphemeralStorageBuilder builder;

        EphemeralStorageStorageNestedImpl(EphemeralStorage item) {
            this.builder = new EphemeralStorageBuilder(this, item);
        }

        EphemeralStorageStorageNestedImpl() {
            this.builder = new EphemeralStorageBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withEphemeralStorageStorage(this.builder.build());
        }

        @Override
        public N endEphemeralStorageStorage() {
            return this.and();
        }
    }
}

