/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.strimzi.api.kafka.model.KafkaListenerAuthentication;
import io.strimzi.api.kafka.model.KafkaListenerExternalLoadBalancer;
import io.strimzi.api.kafka.model.KafkaListenerExternalNodePort;
import io.strimzi.api.kafka.model.KafkaListenerExternalRoute;
import io.strimzi.crdgenerator.annotations.Description;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="route", value=KafkaListenerExternalRoute.class), @JsonSubTypes.Type(name="loadbalancer", value=KafkaListenerExternalLoadBalancer.class), @JsonSubTypes.Type(name="nodeport", value=KafkaListenerExternalNodePort.class)})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class KafkaListenerExternal
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> additionalProperties;

    @Description(value="Type of the external listener. Currently the supported types are `route`, `loadbalancer`, and `nodeport`. \n\n* `route` type uses OpenShift Routes to expose Kafka.* `loadbalancer` type uses LoadBalancer type services to expose Kafka.* `nodeport` type uses NodePort type services to expose Kafka.")
    @JsonIgnore
    public abstract String getType();

    @Description(value="Authentication configuration for Kafka brokers")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="authentication")
    public abstract KafkaListenerAuthentication getAuth();

    public abstract void setAuth(KafkaListenerAuthentication var1);

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(name, value);
    }
}

