/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.KafkaListeners;
import io.strimzi.api.kafka.model.KafkaListenersFluent;
import io.strimzi.api.kafka.model.KafkaListenersFluentImpl;

public class KafkaListenersBuilder
extends KafkaListenersFluentImpl<KafkaListenersBuilder>
implements VisitableBuilder<KafkaListeners, KafkaListenersBuilder> {
    KafkaListenersFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaListenersBuilder() {
        this(true);
    }

    public KafkaListenersBuilder(Boolean validationEnabled) {
        this(new KafkaListeners(), validationEnabled);
    }

    public KafkaListenersBuilder(KafkaListenersFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KafkaListenersBuilder(KafkaListenersFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KafkaListeners(), validationEnabled);
    }

    public KafkaListenersBuilder(KafkaListenersFluent<?> fluent, KafkaListeners instance) {
        this(fluent, instance, true);
    }

    public KafkaListenersBuilder(KafkaListenersFluent<?> fluent, KafkaListeners instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withTls(instance.getTls());
        fluent.withPlain(instance.getPlain());
        fluent.withExternal(instance.getExternal());
        this.validationEnabled = validationEnabled;
    }

    public KafkaListenersBuilder(KafkaListeners instance) {
        this(instance, (Boolean)true);
    }

    public KafkaListenersBuilder(KafkaListeners instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withTls(instance.getTls());
        this.withPlain(instance.getPlain());
        this.withExternal(instance.getExternal());
        this.validationEnabled = validationEnabled;
    }

    public KafkaListeners build() {
        KafkaListeners buildable = new KafkaListeners();
        buildable.setTls(this.fluent.getTls());
        buildable.setPlain(this.fluent.getPlain());
        buildable.setExternal(this.fluent.getExternal());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaListenersBuilder that = (KafkaListenersBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

