/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.strimzi.api.kafka.model.Storage;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PersistentClaimStorage
extends Storage {
    private static final long serialVersionUID = 1L;
    private String size;
    private String storageClass;
    private Map<String, String> selector;
    private boolean deleteClaim;

    @Override
    @Description(value="Must be `persistent-claim`")
    public String getType() {
        return "persistent-claim";
    }

    @Description(value="When type=persistent-claim, defines the size of the persistent volume claim (i.e 1Gi). Mandatory when type=persistent-claim.")
    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    @JsonProperty(value="class")
    @Description(value="The storage class to use for dynamic volume allocation.")
    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    @Description(value="Specifies a specific persistent volume to use. It contains a matchLabels field which defines an inner JSON object with key:value representing labels for selecting such a volume.")
    public Map<String, String> getSelector() {
        return this.selector;
    }

    public void setSelector(Map<String, String> selector) {
        this.selector = selector;
    }

    @Description(value="Specifies if the persistent volume claim has to be deleted when the cluster is un-deployed.")
    @JsonProperty(defaultValue="false")
    public boolean isDeleteClaim() {
        return this.deleteClaim;
    }

    public void setDeleteClaim(boolean deleteClaim) {
        this.deleteClaim = deleteClaim;
    }
}

