/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.PersistentClaimStorage;
import io.strimzi.api.kafka.model.PersistentClaimStorageFluent;
import java.util.LinkedHashMap;
import java.util.Map;

public class PersistentClaimStorageFluentImpl<A extends PersistentClaimStorageFluent<A>>
extends BaseFluent<A>
implements PersistentClaimStorageFluent<A> {
    private String size;
    private String storageClass;
    private Map<String, String> selector;
    private boolean deleteClaim;

    public PersistentClaimStorageFluentImpl() {
    }

    public PersistentClaimStorageFluentImpl(PersistentClaimStorage instance) {
        this.withSize(instance.getSize());
        this.withStorageClass(instance.getStorageClass());
        this.withSelector(instance.getSelector());
        this.withDeleteClaim(instance.isDeleteClaim());
    }

    @Override
    public String getSize() {
        return this.size;
    }

    @Override
    public A withSize(String size) {
        this.size = size;
        return (A)this;
    }

    @Override
    public Boolean hasSize() {
        return this.size != null;
    }

    @Override
    public String getStorageClass() {
        return this.storageClass;
    }

    @Override
    public A withStorageClass(String storageClass) {
        this.storageClass = storageClass;
        return (A)this;
    }

    @Override
    public Boolean hasStorageClass() {
        return this.storageClass != null;
    }

    @Override
    public A addToSelector(String key, String value) {
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToSelector(Map<String, String> map) {
        if (map != null) {
            this.selector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(String key) {
        if (key != null && this.selector != null) {
            this.selector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.selector == null) continue;
                this.selector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getSelector() {
        return this.selector;
    }

    @Override
    public A withSelector(Map<String, String> selector) {
        if (this.selector == null) {
            this.selector = new LinkedHashMap<String, String>();
        } else {
            this.selector.clear();
        }
        if (selector != null) {
            this.selector.putAll(selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public boolean isDeleteClaim() {
        return this.deleteClaim;
    }

    @Override
    public A withDeleteClaim(boolean deleteClaim) {
        this.deleteClaim = deleteClaim;
        return (A)this;
    }

    @Override
    public Boolean hasDeleteClaim() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PersistentClaimStorageFluentImpl that = (PersistentClaimStorageFluentImpl)o;
        if (this.size != null ? !this.size.equals(that.size) : that.size != null) {
            return false;
        }
        if (this.storageClass != null ? !this.storageClass.equals(that.storageClass) : that.storageClass != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        return this.deleteClaim == that.deleteClaim;
    }
}

