/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.Probe;
import io.strimzi.api.kafka.model.ProbeFluent;
import io.strimzi.api.kafka.model.ProbeFluentImpl;

public class ProbeBuilder
extends ProbeFluentImpl<ProbeBuilder>
implements VisitableBuilder<Probe, ProbeBuilder> {
    ProbeFluent<?> fluent;
    Boolean validationEnabled;

    public ProbeBuilder() {
        this(true);
    }

    public ProbeBuilder(Boolean validationEnabled) {
        this(new Probe(), validationEnabled);
    }

    public ProbeBuilder(ProbeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ProbeBuilder(ProbeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Probe(), validationEnabled);
    }

    public ProbeBuilder(ProbeFluent<?> fluent, Probe instance) {
        this(fluent, instance, true);
    }

    public ProbeBuilder(ProbeFluent<?> fluent, Probe instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds());
        fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.validationEnabled = validationEnabled;
    }

    public ProbeBuilder(Probe instance) {
        this(instance, (Boolean)true);
    }

    public ProbeBuilder(Probe instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
        this.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.validationEnabled = validationEnabled;
    }

    public Probe build() {
        Probe buildable = new Probe(this.fluent.getInitialDelaySeconds(), this.fluent.getTimeoutSeconds());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProbeBuilder that = (ProbeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

