/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Affinity;
import io.strimzi.api.kafka.model.EntityTopicOperatorSpecFluentImpl;
import io.strimzi.api.kafka.model.Sidecar;
import io.strimzi.api.kafka.model.SidecarBuilder;
import io.strimzi.api.kafka.model.SidecarFluentImpl;
import io.strimzi.api.kafka.model.TopicOperatorSpec;
import io.strimzi.api.kafka.model.TopicOperatorSpecFluent;

public class TopicOperatorSpecFluentImpl<A extends TopicOperatorSpecFluent<A>>
extends EntityTopicOperatorSpecFluentImpl<A>
implements TopicOperatorSpecFluent<A> {
    private Affinity affinity;
    private SidecarBuilder tlsSidecar;

    public TopicOperatorSpecFluentImpl() {
    }

    public TopicOperatorSpecFluentImpl(TopicOperatorSpec instance) {
        this.withAffinity(instance.getAffinity());
        this.withTlsSidecar(instance.getTlsSidecar());
        this.withWatchedNamespace(instance.getWatchedNamespace());
        this.withImage(instance.getImage());
        this.withReconciliationIntervalSeconds(instance.getReconciliationIntervalSeconds());
        this.withZookeeperSessionTimeoutSeconds(instance.getZookeeperSessionTimeoutSeconds());
        this.withTopicMetadataMaxAttempts(instance.getTopicMetadataMaxAttempts());
        this.withResources(instance.getResources());
        this.withLogging(instance.getLogging());
    }

    @Override
    public Affinity getAffinity() {
        return this.affinity;
    }

    @Override
    public A withAffinity(Affinity affinity) {
        this.affinity = affinity;
        return (A)this;
    }

    @Override
    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    @Override
    @Deprecated
    public Sidecar getTlsSidecar() {
        return this.tlsSidecar != null ? this.tlsSidecar.build() : null;
    }

    @Override
    public Sidecar buildTlsSidecar() {
        return this.tlsSidecar != null ? this.tlsSidecar.build() : null;
    }

    @Override
    public A withTlsSidecar(Sidecar tlsSidecar) {
        this._visitables.remove(this.tlsSidecar);
        if (tlsSidecar != null) {
            this.tlsSidecar = new SidecarBuilder(tlsSidecar);
            this._visitables.add(this.tlsSidecar);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsSidecar() {
        return this.tlsSidecar != null;
    }

    @Override
    public TopicOperatorSpecFluent.TlsSidecarNested<A> withNewTlsSidecar() {
        return new TlsSidecarNestedImpl();
    }

    @Override
    public TopicOperatorSpecFluent.TlsSidecarNested<A> withNewTlsSidecarLike(Sidecar item) {
        return new TlsSidecarNestedImpl(item);
    }

    @Override
    public TopicOperatorSpecFluent.TlsSidecarNested<A> editTlsSidecar() {
        return this.withNewTlsSidecarLike(this.getTlsSidecar());
    }

    @Override
    public TopicOperatorSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecar() {
        return this.withNewTlsSidecarLike(this.getTlsSidecar() != null ? this.getTlsSidecar() : new SidecarBuilder().build());
    }

    @Override
    public TopicOperatorSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecarLike(Sidecar item) {
        return this.withNewTlsSidecarLike(this.getTlsSidecar() != null ? this.getTlsSidecar() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TopicOperatorSpecFluentImpl that = (TopicOperatorSpecFluentImpl)o;
        if (this.affinity != null ? !this.affinity.equals((Object)that.affinity) : that.affinity != null) {
            return false;
        }
        return !(this.tlsSidecar != null ? !this.tlsSidecar.equals(that.tlsSidecar) : that.tlsSidecar != null);
    }

    public class TlsSidecarNestedImpl<N>
    extends SidecarFluentImpl<TopicOperatorSpecFluent.TlsSidecarNested<N>>
    implements TopicOperatorSpecFluent.TlsSidecarNested<N>,
    Nested<N> {
        private final SidecarBuilder builder;

        TlsSidecarNestedImpl(Sidecar item) {
            this.builder = new SidecarBuilder(this, item);
        }

        TlsSidecarNestedImpl() {
            this.builder = new SidecarBuilder(this);
        }

        @Override
        public N and() {
            return (N)TopicOperatorSpecFluentImpl.this.withTlsSidecar(this.builder.build());
        }

        @Override
        public N endTlsSidecar() {
            return this.and();
        }
    }
}

