/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.Toleration;
import io.strimzi.api.kafka.model.EphemeralStorage;
import io.strimzi.api.kafka.model.EphemeralStorageBuilder;
import io.strimzi.api.kafka.model.EphemeralStorageFluentImpl;
import io.strimzi.api.kafka.model.ExternalLogging;
import io.strimzi.api.kafka.model.ExternalLoggingBuilder;
import io.strimzi.api.kafka.model.ExternalLoggingFluentImpl;
import io.strimzi.api.kafka.model.InlineLogging;
import io.strimzi.api.kafka.model.InlineLoggingBuilder;
import io.strimzi.api.kafka.model.InlineLoggingFluentImpl;
import io.strimzi.api.kafka.model.JvmOptions;
import io.strimzi.api.kafka.model.JvmOptionsBuilder;
import io.strimzi.api.kafka.model.JvmOptionsFluentImpl;
import io.strimzi.api.kafka.model.Logging;
import io.strimzi.api.kafka.model.PersistentClaimStorage;
import io.strimzi.api.kafka.model.PersistentClaimStorageBuilder;
import io.strimzi.api.kafka.model.PersistentClaimStorageFluentImpl;
import io.strimzi.api.kafka.model.Probe;
import io.strimzi.api.kafka.model.ProbeBuilder;
import io.strimzi.api.kafka.model.ProbeFluentImpl;
import io.strimzi.api.kafka.model.Resources;
import io.strimzi.api.kafka.model.ResourcesBuilder;
import io.strimzi.api.kafka.model.ResourcesFluentImpl;
import io.strimzi.api.kafka.model.Sidecar;
import io.strimzi.api.kafka.model.SidecarBuilder;
import io.strimzi.api.kafka.model.SidecarFluentImpl;
import io.strimzi.api.kafka.model.Storage;
import io.strimzi.api.kafka.model.ZookeeperClusterSpec;
import io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ZookeeperClusterSpecFluentImpl<A extends ZookeeperClusterSpecFluent<A>>
extends BaseFluent<A>
implements ZookeeperClusterSpecFluent<A> {
    private VisitableBuilder<? extends Storage, ?> storage;
    private Map<String, Object> config;
    private VisitableBuilder<? extends Logging, ?> logging;
    private SidecarBuilder tlsSidecar;
    private int replicas;
    private String image;
    private ResourcesBuilder resources;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private JvmOptionsBuilder jvmOptions;
    private Map<String, Object> metrics;
    private Affinity affinity;
    private List<Toleration> tolerations;

    public ZookeeperClusterSpecFluentImpl() {
    }

    public ZookeeperClusterSpecFluentImpl(ZookeeperClusterSpec instance) {
        this.withStorage(instance.getStorage());
        this.withConfig(instance.getConfig());
        this.withLogging(instance.getLogging());
        this.withTlsSidecar(instance.getTlsSidecar());
        this.withReplicas(instance.getReplicas());
        this.withImage(instance.getImage());
        this.withResources(instance.getResources());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withJvmOptions(instance.getJvmOptions());
        this.withMetrics(instance.getMetrics());
        this.withAffinity(instance.getAffinity());
        this.withTolerations(instance.getTolerations());
    }

    @Override
    @Deprecated
    public Storage getStorage() {
        return this.storage != null ? (Storage)this.storage.build() : null;
    }

    @Override
    public Storage buildStorage() {
        return this.storage != null ? (Storage)this.storage.build() : null;
    }

    @Override
    public A withStorage(Storage storage) {
        if (storage instanceof EphemeralStorage) {
            this.storage = new EphemeralStorageBuilder((EphemeralStorage)storage);
            this._visitables.add(this.storage);
        }
        if (storage instanceof PersistentClaimStorage) {
            this.storage = new PersistentClaimStorageBuilder((PersistentClaimStorage)storage);
            this._visitables.add(this.storage);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStorage() {
        return this.storage != null;
    }

    @Override
    public A withEphemeralStorageStorage(EphemeralStorage ephemeralStorageStorage) {
        this._visitables.remove(this.storage);
        if (ephemeralStorageStorage != null) {
            this.storage = new EphemeralStorageBuilder(ephemeralStorageStorage);
            this._visitables.add(this.storage);
        }
        return (A)this;
    }

    @Override
    public ZookeeperClusterSpecFluent.EphemeralStorageStorageNested<A> withNewEphemeralStorageStorage() {
        return new EphemeralStorageStorageNestedImpl();
    }

    @Override
    public ZookeeperClusterSpecFluent.EphemeralStorageStorageNested<A> withNewEphemeralStorageStorageLike(EphemeralStorage item) {
        return new EphemeralStorageStorageNestedImpl(item);
    }

    @Override
    public A withPersistentClaimStorageStorage(PersistentClaimStorage persistentClaimStorageStorage) {
        this._visitables.remove(this.storage);
        if (persistentClaimStorageStorage != null) {
            this.storage = new PersistentClaimStorageBuilder(persistentClaimStorageStorage);
            this._visitables.add(this.storage);
        }
        return (A)this;
    }

    @Override
    public ZookeeperClusterSpecFluent.PersistentClaimStorageStorageNested<A> withNewPersistentClaimStorageStorage() {
        return new PersistentClaimStorageStorageNestedImpl();
    }

    @Override
    public ZookeeperClusterSpecFluent.PersistentClaimStorageStorageNested<A> withNewPersistentClaimStorageStorageLike(PersistentClaimStorage item) {
        return new PersistentClaimStorageStorageNestedImpl(item);
    }

    @Override
    public A addToConfig(String key, Object value) {
        if (key != null && value != null) {
            this.config.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToConfig(Map<String, Object> map) {
        if (map != null) {
            this.config.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(String key) {
        if (key != null && this.config != null) {
            this.config.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.config == null) continue;
                this.config.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @Override
    public A withConfig(Map<String, Object> config) {
        if (this.config == null) {
            this.config = new LinkedHashMap<String, Object>();
        } else {
            this.config.clear();
        }
        if (config != null) {
            this.config.putAll(config);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfig() {
        return this.config != null;
    }

    @Override
    @Deprecated
    public Logging getLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    @Override
    public Logging buildLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    @Override
    public A withLogging(Logging logging) {
        if (logging instanceof ExternalLogging) {
            this.logging = new ExternalLoggingBuilder((ExternalLogging)logging);
            this._visitables.add(this.logging);
        }
        if (logging instanceof InlineLogging) {
            this.logging = new InlineLoggingBuilder((InlineLogging)logging);
            this._visitables.add(this.logging);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLogging() {
        return this.logging != null;
    }

    @Override
    public A withExternalLoggingLogging(ExternalLogging externalLoggingLogging) {
        this._visitables.remove(this.logging);
        if (externalLoggingLogging != null) {
            this.logging = new ExternalLoggingBuilder(externalLoggingLogging);
            this._visitables.add(this.logging);
        }
        return (A)this;
    }

    @Override
    public ZookeeperClusterSpecFluent.ExternalLoggingLoggingNested<A> withNewExternalLoggingLogging() {
        return new ExternalLoggingLoggingNestedImpl();
    }

    @Override
    public ZookeeperClusterSpecFluent.ExternalLoggingLoggingNested<A> withNewExternalLoggingLoggingLike(ExternalLogging item) {
        return new ExternalLoggingLoggingNestedImpl(item);
    }

    @Override
    public A withInlineLoggingLogging(InlineLogging inlineLoggingLogging) {
        this._visitables.remove(this.logging);
        if (inlineLoggingLogging != null) {
            this.logging = new InlineLoggingBuilder(inlineLoggingLogging);
            this._visitables.add(this.logging);
        }
        return (A)this;
    }

    @Override
    public ZookeeperClusterSpecFluent.InlineLoggingLoggingNested<A> withNewInlineLoggingLogging() {
        return new InlineLoggingLoggingNestedImpl();
    }

    @Override
    public ZookeeperClusterSpecFluent.InlineLoggingLoggingNested<A> withNewInlineLoggingLoggingLike(InlineLogging item) {
        return new InlineLoggingLoggingNestedImpl(item);
    }

    @Override
    @Deprecated
    public Sidecar getTlsSidecar() {
        return this.tlsSidecar != null ? this.tlsSidecar.build() : null;
    }

    @Override
    public Sidecar buildTlsSidecar() {
        return this.tlsSidecar != null ? this.tlsSidecar.build() : null;
    }

    @Override
    public A withTlsSidecar(Sidecar tlsSidecar) {
        this._visitables.remove(this.tlsSidecar);
        if (tlsSidecar != null) {
            this.tlsSidecar = new SidecarBuilder(tlsSidecar);
            this._visitables.add(this.tlsSidecar);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsSidecar() {
        return this.tlsSidecar != null;
    }

    @Override
    public ZookeeperClusterSpecFluent.TlsSidecarNested<A> withNewTlsSidecar() {
        return new TlsSidecarNestedImpl();
    }

    @Override
    public ZookeeperClusterSpecFluent.TlsSidecarNested<A> withNewTlsSidecarLike(Sidecar item) {
        return new TlsSidecarNestedImpl(item);
    }

    @Override
    public ZookeeperClusterSpecFluent.TlsSidecarNested<A> editTlsSidecar() {
        return this.withNewTlsSidecarLike(this.getTlsSidecar());
    }

    @Override
    public ZookeeperClusterSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecar() {
        return this.withNewTlsSidecarLike(this.getTlsSidecar() != null ? this.getTlsSidecar() : new SidecarBuilder().build());
    }

    @Override
    public ZookeeperClusterSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecarLike(Sidecar item) {
        return this.withNewTlsSidecarLike(this.getTlsSidecar() != null ? this.getTlsSidecar() : item);
    }

    @Override
    public int getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(int replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return true;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    @Deprecated
    public Resources getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public Resources buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(Resources resources) {
        this._visitables.remove(this.resources);
        if (resources != null) {
            this.resources = new ResourcesBuilder(resources);
            this._visitables.add(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public ZookeeperClusterSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public ZookeeperClusterSpecFluent.ResourcesNested<A> withNewResourcesLike(Resources item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public ZookeeperClusterSpecFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public ZookeeperClusterSpecFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new ResourcesBuilder().build());
    }

    @Override
    public ZookeeperClusterSpecFluent.ResourcesNested<A> editOrNewResourcesLike(Resources item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    @Override
    @Deprecated
    public Probe getLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.remove(this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.add(this.livenessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    @Override
    public A withNewLivenessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    @Override
    public ZookeeperClusterSpecFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNestedImpl();
    }

    @Override
    public ZookeeperClusterSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNestedImpl(item);
    }

    @Override
    public ZookeeperClusterSpecFluent.LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe());
    }

    @Override
    public ZookeeperClusterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : new ProbeBuilder().build());
    }

    @Override
    public ZookeeperClusterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : item);
    }

    @Override
    @Deprecated
    public Probe getReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.remove(this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.add(this.readinessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    @Override
    public A withNewReadinessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    @Override
    public ZookeeperClusterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNestedImpl();
    }

    @Override
    public ZookeeperClusterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNestedImpl(item);
    }

    @Override
    public ZookeeperClusterSpecFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe());
    }

    @Override
    public ZookeeperClusterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : new ProbeBuilder().build());
    }

    @Override
    public ZookeeperClusterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : item);
    }

    @Override
    @Deprecated
    public JvmOptions getJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    @Override
    public JvmOptions buildJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    @Override
    public A withJvmOptions(JvmOptions jvmOptions) {
        this._visitables.remove(this.jvmOptions);
        if (jvmOptions != null) {
            this.jvmOptions = new JvmOptionsBuilder(jvmOptions);
            this._visitables.add(this.jvmOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    @Override
    public ZookeeperClusterSpecFluent.JvmOptionsNested<A> withNewJvmOptions() {
        return new JvmOptionsNestedImpl();
    }

    @Override
    public ZookeeperClusterSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
        return new JvmOptionsNestedImpl(item);
    }

    @Override
    public ZookeeperClusterSpecFluent.JvmOptionsNested<A> editJvmOptions() {
        return this.withNewJvmOptionsLike(this.getJvmOptions());
    }

    @Override
    public ZookeeperClusterSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions() {
        return this.withNewJvmOptionsLike(this.getJvmOptions() != null ? this.getJvmOptions() : new JvmOptionsBuilder().build());
    }

    @Override
    public ZookeeperClusterSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
        return this.withNewJvmOptionsLike(this.getJvmOptions() != null ? this.getJvmOptions() : item);
    }

    @Override
    public A addToMetrics(String key, Object value) {
        if (key != null && value != null) {
            this.metrics.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToMetrics(Map<String, Object> map) {
        if (map != null) {
            this.metrics.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetrics(String key) {
        if (key != null && this.metrics != null) {
            this.metrics.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetrics(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.metrics == null) continue;
                this.metrics.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getMetrics() {
        return this.metrics;
    }

    @Override
    public A withMetrics(Map<String, Object> metrics) {
        if (this.metrics == null) {
            this.metrics = new LinkedHashMap<String, Object>();
        } else {
            this.metrics.clear();
        }
        if (metrics != null) {
            this.metrics.putAll(metrics);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetrics() {
        return this.metrics != null;
    }

    @Override
    public Affinity getAffinity() {
        return this.affinity;
    }

    @Override
    public A withAffinity(Affinity affinity) {
        this.affinity = affinity;
        return (A)this;
    }

    @Override
    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    @Override
    public A addToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTolerations(int index, Toleration item) {
        this.tolerations.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTolerations(Toleration ... items) {
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTolerations(Toleration ... items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    @Override
    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    @Override
    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    @Override
    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    @Override
    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withTolerations(List<Toleration> tolerations) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        } else {
            this._visitables.removeAll(this.tolerations);
            this.tolerations.clear();
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withTolerations(Toleration ... tolerations) {
        this.tolerations.clear();
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ZookeeperClusterSpecFluentImpl that = (ZookeeperClusterSpecFluentImpl)o;
        if (this.storage != null ? !this.storage.equals(that.storage) : that.storage != null) {
            return false;
        }
        if (this.config != null ? !this.config.equals(that.config) : that.config != null) {
            return false;
        }
        if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) {
            return false;
        }
        if (this.tlsSidecar != null ? !this.tlsSidecar.equals(that.tlsSidecar) : that.tlsSidecar != null) {
            return false;
        }
        if (this.replicas != that.replicas) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.livenessProbe != null ? !this.livenessProbe.equals(that.livenessProbe) : that.livenessProbe != null) {
            return false;
        }
        if (this.readinessProbe != null ? !this.readinessProbe.equals(that.readinessProbe) : that.readinessProbe != null) {
            return false;
        }
        if (this.jvmOptions != null ? !this.jvmOptions.equals(that.jvmOptions) : that.jvmOptions != null) {
            return false;
        }
        if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) {
            return false;
        }
        if (this.affinity != null ? !this.affinity.equals((Object)that.affinity) : that.affinity != null) {
            return false;
        }
        return !(this.tolerations != null ? !this.tolerations.equals(that.tolerations) : that.tolerations != null);
    }

    public class JvmOptionsNestedImpl<N>
    extends JvmOptionsFluentImpl<ZookeeperClusterSpecFluent.JvmOptionsNested<N>>
    implements ZookeeperClusterSpecFluent.JvmOptionsNested<N>,
    Nested<N> {
        private final JvmOptionsBuilder builder;

        JvmOptionsNestedImpl(JvmOptions item) {
            this.builder = new JvmOptionsBuilder(this, item);
        }

        JvmOptionsNestedImpl() {
            this.builder = new JvmOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)ZookeeperClusterSpecFluentImpl.this.withJvmOptions(this.builder.build());
        }

        @Override
        public N endJvmOptions() {
            return this.and();
        }
    }

    public class ReadinessProbeNestedImpl<N>
    extends ProbeFluentImpl<ZookeeperClusterSpecFluent.ReadinessProbeNested<N>>
    implements ZookeeperClusterSpecFluent.ReadinessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        ReadinessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        ReadinessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)ZookeeperClusterSpecFluentImpl.this.withReadinessProbe(this.builder.build());
        }

        @Override
        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class LivenessProbeNestedImpl<N>
    extends ProbeFluentImpl<ZookeeperClusterSpecFluent.LivenessProbeNested<N>>
    implements ZookeeperClusterSpecFluent.LivenessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        LivenessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        LivenessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)ZookeeperClusterSpecFluentImpl.this.withLivenessProbe(this.builder.build());
        }

        @Override
        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class ResourcesNestedImpl<N>
    extends ResourcesFluentImpl<ZookeeperClusterSpecFluent.ResourcesNested<N>>
    implements ZookeeperClusterSpecFluent.ResourcesNested<N>,
    Nested<N> {
        private final ResourcesBuilder builder;

        ResourcesNestedImpl(Resources item) {
            this.builder = new ResourcesBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourcesBuilder(this);
        }

        @Override
        public N and() {
            return (N)ZookeeperClusterSpecFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    public class TlsSidecarNestedImpl<N>
    extends SidecarFluentImpl<ZookeeperClusterSpecFluent.TlsSidecarNested<N>>
    implements ZookeeperClusterSpecFluent.TlsSidecarNested<N>,
    Nested<N> {
        private final SidecarBuilder builder;

        TlsSidecarNestedImpl(Sidecar item) {
            this.builder = new SidecarBuilder(this, item);
        }

        TlsSidecarNestedImpl() {
            this.builder = new SidecarBuilder(this);
        }

        @Override
        public N and() {
            return (N)ZookeeperClusterSpecFluentImpl.this.withTlsSidecar(this.builder.build());
        }

        @Override
        public N endTlsSidecar() {
            return this.and();
        }
    }

    public class InlineLoggingLoggingNestedImpl<N>
    extends InlineLoggingFluentImpl<ZookeeperClusterSpecFluent.InlineLoggingLoggingNested<N>>
    implements ZookeeperClusterSpecFluent.InlineLoggingLoggingNested<N>,
    Nested<N> {
        private final InlineLoggingBuilder builder;

        InlineLoggingLoggingNestedImpl(InlineLogging item) {
            this.builder = new InlineLoggingBuilder(this, item);
        }

        InlineLoggingLoggingNestedImpl() {
            this.builder = new InlineLoggingBuilder(this);
        }

        @Override
        public N and() {
            return (N)ZookeeperClusterSpecFluentImpl.this.withInlineLoggingLogging(this.builder.build());
        }

        @Override
        public N endInlineLoggingLogging() {
            return this.and();
        }
    }

    public class ExternalLoggingLoggingNestedImpl<N>
    extends ExternalLoggingFluentImpl<ZookeeperClusterSpecFluent.ExternalLoggingLoggingNested<N>>
    implements ZookeeperClusterSpecFluent.ExternalLoggingLoggingNested<N>,
    Nested<N> {
        private final ExternalLoggingBuilder builder;

        ExternalLoggingLoggingNestedImpl(ExternalLogging item) {
            this.builder = new ExternalLoggingBuilder(this, item);
        }

        ExternalLoggingLoggingNestedImpl() {
            this.builder = new ExternalLoggingBuilder(this);
        }

        @Override
        public N and() {
            return (N)ZookeeperClusterSpecFluentImpl.this.withExternalLoggingLogging(this.builder.build());
        }

        @Override
        public N endExternalLoggingLogging() {
            return this.and();
        }
    }

    public class PersistentClaimStorageStorageNestedImpl<N>
    extends PersistentClaimStorageFluentImpl<ZookeeperClusterSpecFluent.PersistentClaimStorageStorageNested<N>>
    implements ZookeeperClusterSpecFluent.PersistentClaimStorageStorageNested<N>,
    Nested<N> {
        private final PersistentClaimStorageBuilder builder;

        PersistentClaimStorageStorageNestedImpl(PersistentClaimStorage item) {
            this.builder = new PersistentClaimStorageBuilder(this, item);
        }

        PersistentClaimStorageStorageNestedImpl() {
            this.builder = new PersistentClaimStorageBuilder(this);
        }

        @Override
        public N and() {
            return (N)ZookeeperClusterSpecFluentImpl.this.withPersistentClaimStorageStorage(this.builder.build());
        }

        @Override
        public N endPersistentClaimStorageStorage() {
            return this.and();
        }
    }

    public class EphemeralStorageStorageNestedImpl<N>
    extends EphemeralStorageFluentImpl<ZookeeperClusterSpecFluent.EphemeralStorageStorageNested<N>>
    implements ZookeeperClusterSpecFluent.EphemeralStorageStorageNested<N>,
    Nested<N> {
        private final EphemeralStorageBuilder builder;

        EphemeralStorageStorageNestedImpl(EphemeralStorage item) {
            this.builder = new EphemeralStorageBuilder(this, item);
        }

        EphemeralStorageStorageNestedImpl() {
            this.builder = new EphemeralStorageBuilder(this);
        }

        @Override
        public N and() {
            return (N)ZookeeperClusterSpecFluentImpl.this.withEphemeralStorageStorage(this.builder.build());
        }

        @Override
        public N endEphemeralStorageStorage() {
            return this.and();
        }
    }
}

