/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.maven;

import io.sundr.maven.ArtifactHandlerUtil;
import io.sundr.utils.Strings;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;

public abstract class AbstractSundrioMojo
extends AbstractMojo {
    static final String BOM_NAME = "pom.xml";
    static final String POM_TYPE = "pom";
    static final String PLUGIN_TYPE = "maven-plugin";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojo;
    @Parameter(defaultValue="${project.distributionManagementArtifactRepository}", readonly=true, required=false)
    private ArtifactRepository deploymentRepository;
    @Parameter(defaultValue="${altDeploymentRepository}", readonly=true, required=false)
    private String altDeploymentRepository;

    public MavenProject getProject() {
        return this.project;
    }

    public MavenSession getSession() {
        return this.session;
    }

    MavenProject readProject(File pomFile) throws IOException {
        MavenXpp3Reader mavenReader = new MavenXpp3Reader();
        try (FileReader fileReader = null;){
            fileReader = new FileReader(pomFile);
            Model model = mavenReader.read((Reader)fileReader);
            model.setPomFile(pomFile);
            MavenProject project = new MavenProject(model);
            project.setFile(pomFile);
            project.setArtifact(this.createArtifact(pomFile, model.getGroupId(), model.getArtifactId(), model.getVersion(), "compile", model.getPackaging(), ""));
            MavenProject mavenProject = project;
            return mavenProject;
        }
    }

    Artifact createArtifact(File file, String groupId, String artifactId, String version, String scope, String type, String classifier) {
        return ArtifactHandlerUtil.newArtifact(groupId, artifactId, version, scope, type, classifier);
    }

    void backGroundBuild(MavenProject project) throws MojoExecutionException {
        MavenExecutionRequest executionRequest = this.session.getRequest();
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setBaseDirectory(project.getBasedir());
        request.setPomFile(project.getFile());
        request.setGoals(executionRequest.getGoals());
        request.setRecursive(false);
        request.setBatchMode(false);
        request.setProfiles(executionRequest.getActiveProfiles());
        request.setProperties(executionRequest.getUserProperties());
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            InvocationResult result = invoker.execute((InvocationRequest)request);
            if (result.getExitCode() != 0) {
                throw new IllegalStateException("Error invoking Maven goals:[" + Strings.join((Iterable)executionRequest.getGoals(), (String)", ") + "]", (Throwable)result.getExecutionException());
            }
        }
        catch (MavenInvocationException e) {
            throw new IllegalStateException("Error invoking Maven goals:[" + Strings.join((Iterable)executionRequest.getGoals(), (String)", ") + "]", e);
        }
    }
}

