/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.maven;

import io.sundr.maven.ArtifactHandlerUtil;
import io.sundr.maven.BomConfig;
import io.sundr.maven.BomImport;
import io.sundr.maven.filter.Filters;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;

public class ExternalBomResolver {
    private MavenSession mavenSession;
    private RepositorySystem system;
    private RepositorySystemSession session;
    private List<RemoteRepository> remoteRepositories;
    private Log logger;

    public ExternalBomResolver(MavenSession mavenSession, RepositorySystem system, RepositorySystemSession session, List<RemoteRepository> remoteRepositories, Log logger) {
        this.mavenSession = mavenSession;
        this.system = system;
        this.session = session;
        this.remoteRepositories = remoteRepositories;
        this.logger = logger;
    }

    public Map<org.apache.maven.artifact.Artifact, Dependency> resolve(BomConfig config) throws Exception {
        LinkedHashMap<org.apache.maven.artifact.Artifact, Dependency> dependencies = new LinkedHashMap<org.apache.maven.artifact.Artifact, Dependency>();
        if (config != null && config.getImports() != null) {
            for (BomImport bom : config.getImports()) {
                Map<org.apache.maven.artifact.Artifact, Dependency> deps = this.resolve(bom);
                for (Map.Entry<org.apache.maven.artifact.Artifact, Dependency> e : deps.entrySet()) {
                    if (dependencies.containsKey(e.getKey())) continue;
                    dependencies.put(e.getKey(), e.getValue());
                }
            }
        }
        return dependencies;
    }

    private Map<org.apache.maven.artifact.Artifact, Dependency> resolve(BomImport bom) throws Exception {
        this.logger.info((CharSequence)("Resolving " + String.valueOf(bom) + " to get managed dependencies "));
        Map<org.apache.maven.artifact.Artifact, Dependency> dependencies = this.resolveDependencies(bom);
        Map<org.apache.maven.artifact.Artifact, Dependency> filteredDependencies = Filters.filter(dependencies, Filters.createDependencyManagementFilter(this.mavenSession, bom));
        int included = filteredDependencies.size();
        int total = dependencies.size();
        this.logger.info((CharSequence)("Included " + included + "/" + total + " dependencies from BOM " + String.valueOf(bom)));
        return filteredDependencies;
    }

    private Map<org.apache.maven.artifact.Artifact, Dependency> resolveDependencies(BomImport bom) throws Exception {
        DefaultArtifact artifact = new DefaultArtifact(bom.getGroupId(), bom.getArtifactId(), "pom", bom.getVersion());
        List<RemoteRepository> repositories = this.remoteRepositories;
        if (bom.getRepository() != null) {
            repositories = new LinkedList<RemoteRepository>(repositories);
            RemoteRepository repo = new RemoteRepository.Builder(bom.getArtifactId() + "-repository", "default", bom.getRepository()).build();
            repositories.add(0, repo);
        }
        ArtifactRequest artifactRequest = new ArtifactRequest((Artifact)artifact, repositories, null);
        this.system.resolveArtifact(this.session, artifactRequest);
        ArtifactDescriptorRequest req = new ArtifactDescriptorRequest((Artifact)artifact, repositories, null);
        ArtifactDescriptorResult res = this.system.readArtifactDescriptor(this.session, req);
        LinkedHashMap<org.apache.maven.artifact.Artifact, Dependency> mavenDependencies = new LinkedHashMap<org.apache.maven.artifact.Artifact, Dependency>();
        if (res.getManagedDependencies() != null) {
            for (org.eclipse.aether.graph.Dependency dep : res.getManagedDependencies()) {
                mavenDependencies.put(this.toMavenArtifact(dep), this.toMavenDependency(dep));
            }
        }
        return mavenDependencies;
    }

    private Dependency toMavenDependency(org.eclipse.aether.graph.Dependency from) {
        Artifact fromArt = from.getArtifact();
        Dependency dependency = new Dependency();
        dependency.setGroupId(fromArt.getGroupId());
        dependency.setArtifactId(fromArt.getArtifactId());
        dependency.setVersion(fromArt.getVersion());
        dependency.setType(fromArt.getExtension());
        dependency.setScope("compile".equals(from.getScope()) ? null : from.getScope());
        dependency.setClassifier(fromArt.getClassifier());
        dependency.setOptional(dependency.isOptional());
        if (from.getExclusions() != null && from.getExclusions().size() > 0) {
            LinkedList<Exclusion> exclusions = new LinkedList<Exclusion>();
            for (org.eclipse.aether.graph.Exclusion fromEx : from.getExclusions()) {
                Exclusion ex = new Exclusion();
                ex.setGroupId(fromEx.getGroupId());
                ex.setArtifactId(fromEx.getArtifactId());
                exclusions.add(ex);
            }
            dependency.setExclusions(exclusions);
        }
        return dependency;
    }

    private org.apache.maven.artifact.Artifact toMavenArtifact(org.eclipse.aether.graph.Dependency dependency) {
        Artifact sa = dependency.getArtifact();
        return ArtifactHandlerUtil.newArtifact(sa.getGroupId(), sa.getArtifactId(), sa.getVersion(), dependency.getScope(), sa.getExtension(), sa.getClassifier());
    }
}

