/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ExtensionProperty;
import io.swagger.converter.ModelConverters;
import io.swagger.models.Model;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.Collections;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ModelPropertyExtensionTest {
    @Test(description="it should parse extensions on a model property")
    public void testHiddenField() {
        Map models = ModelConverters.getInstance().read(ModelWithHiddenFields.class);
        Model model = (Model)models.get("ModelWithHiddenFields");
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((int)model.getProperties().size(), (int)3);
        Property idValue = (Property)model.getProperties().get("id");
        Assert.assertTrue((boolean)(idValue instanceof LongProperty));
        Assert.assertTrue((boolean)idValue.getRequired());
        Property nameValue = (Property)model.getProperties().get("name");
        Assert.assertTrue((boolean)(nameValue instanceof StringProperty));
        Assert.assertEquals((Object)nameValue.getVendorExtensions(), Collections.emptyMap());
        Property extendedValue = (Property)model.getProperties().get("extended");
        Assert.assertTrue((boolean)(extendedValue instanceof StringProperty));
        Assert.assertEquals(extendedValue.getVendorExtensions().get("x-proprietary"), (Object)"corporate");
    }

    class ModelWithHiddenFields {
        @ApiModelProperty(required=true)
        public Long id = null;
        @ApiModelProperty(required=true, hidden=false, extensions={@Extension(properties={})})
        public String name = null;
        @ApiModelProperty(required=true, extensions={@Extension(properties={@ExtensionProperty(name="x-proprietary", value="corporate")})})
        public String extended = null;

        ModelWithHiddenFields() {
        }
    }
}

