/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.annotations.ApiModelProperty;
import io.swagger.converter.ModelConverters;
import io.swagger.util.Json;
import java.math.BigDecimal;
import java.util.Map;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NumericFormatTest {
    private static final String NEWLINE = System.getProperty("line.separator");

    @Test
    public void testFormatOfInteger() {
        Map models = ModelConverters.getInstance().readAll(ModelWithIntegerFields.class);
        Assert.assertEquals((int)models.size(), (int)1);
        String json = Json.pretty((Object)models);
        Assert.assertEquals((String)json, (String)("{" + NEWLINE + "  \"ModelWithIntegerFields\" : {" + NEWLINE + "    \"type\" : \"object\"," + NEWLINE + "    \"properties\" : {" + NEWLINE + "      \"id\" : {" + NEWLINE + "        \"type\" : \"integer\"," + NEWLINE + "        \"format\" : \"int32\"," + NEWLINE + "        \"minimum\" : 3" + NEWLINE + "      }" + NEWLINE + "    }" + NEWLINE + "  }" + NEWLINE + "}"));
    }

    @Test
    public void testFormatOfDecimal() {
        Map models = ModelConverters.getInstance().readAll(ModelWithDecimalFields.class);
        Assert.assertEquals((int)models.size(), (int)1);
        String json = Json.pretty((Object)models);
        Assert.assertEquals((String)json, (String)("{" + NEWLINE + "  \"ModelWithDecimalFields\" : {" + NEWLINE + "    \"type\" : \"object\"," + NEWLINE + "    \"properties\" : {" + NEWLINE + "      \"id\" : {" + NEWLINE + "        \"type\" : \"number\"," + NEWLINE + "        \"format\" : \"double\"," + NEWLINE + "        \"minimum\" : 3.3," + NEWLINE + "        \"exclusiveMinimum\" : false" + NEWLINE + "      }" + NEWLINE + "    }" + NEWLINE + "  }" + NEWLINE + "}"));
    }

    @Test
    public void testFormatOfBigDecimal() {
        Map models = ModelConverters.getInstance().readAll(ModelWithoutScientificFields.class);
        Assert.assertEquals((int)models.size(), (int)1);
        String json = Json.pretty((Object)models);
        Assert.assertEquals((String)json, (String)("{" + NEWLINE + "  \"ModelWithoutScientificFields\" : {" + NEWLINE + "    \"type\" : \"object\"," + NEWLINE + "    \"properties\" : {" + NEWLINE + "      \"id\" : {" + NEWLINE + "        \"type\" : \"number\"," + NEWLINE + "        \"minimum\" : -9999999999999999.99," + NEWLINE + "        \"maximum\" : 9999999999999999.99," + NEWLINE + "        \"exclusiveMinimum\" : false," + NEWLINE + "        \"exclusiveMaximum\" : false" + NEWLINE + "      }" + NEWLINE + "    }" + NEWLINE + "  }" + NEWLINE + "}"));
    }

    static class ModelWithoutScientificFields {
        @ApiModelProperty
        @DecimalMin(value="-9999999999999999.99")
        @DecimalMax(value="9999999999999999.99")
        public @DecimalMin(value="-9999999999999999.99") @DecimalMax(value="9999999999999999.99") BigDecimal id;

        ModelWithoutScientificFields() {
        }
    }

    static class ModelWithDecimalFields {
        @ApiModelProperty
        @DecimalMin(value="3.3")
        public @DecimalMin(value="3.3") Double id;

        ModelWithDecimalFields() {
        }
    }

    static class ModelWithIntegerFields {
        @ApiModelProperty
        @Min(value=3L)
        public @Min(value=3L) Integer id;

        ModelWithIntegerFields() {
        }
    }
}

