/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.util.PathUtils;
import java.util.HashMap;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PathUtilsTest {
    @Test(description="parse regex with slash inside it from issue 1153")
    public void parseRegexWithSlashInside() {
        HashMap regexMap = new HashMap();
        String path = PathUtils.parsePath((String)"/{itemId: [0-9]{4}/[0-9]{2}/[0-9]{2}/[0-9]{2}/[0-9]{2}/[0-9]{2}/[0-9]{3}/[A-Za-z0-9]+}", regexMap);
        Assert.assertEquals((String)path, (String)"/{itemId}");
        Assert.assertEquals((String)((String)regexMap.get("itemId")), (String)"[0-9]{4}/[0-9]{2}/[0-9]{2}/[0-9]{2}/[0-9]{2}/[0-9]{2}/[0-9]{3}/[A-Za-z0-9]+");
    }

    @Test(description="parse two part path with one param")
    public void parseTwoPartPathWithOneParam() {
        HashMap regexMap = new HashMap();
        String path = PathUtils.parsePath((String)"/api/{itemId: [0-9]{4}/[0-9]{2,4}/[A-Za-z0-9]+}", regexMap);
        Assert.assertEquals((String)path, (String)"/api/{itemId}");
        Assert.assertEquals((String)((String)regexMap.get("itemId")), (String)"[0-9]{4}/[0-9]{2,4}/[A-Za-z0-9]+");
    }

    @Test(description="parse two part path with two params and white spaces around")
    public void parseTwoPartPathWithTwoParams() {
        HashMap regexMap = new HashMap();
        String path = PathUtils.parsePath((String)"/{itemId: [0-9]{4}/[A-Za-z0-9]+}/{ api : [aA-zZ]+ }", regexMap);
        Assert.assertEquals((String)path, (String)"/{itemId}/{api}");
        Assert.assertEquals((String)((String)regexMap.get("itemId")), (String)"[0-9]{4}/[A-Za-z0-9]+");
        Assert.assertEquals((String)((String)regexMap.get("api")), (String)"[aA-zZ]+");
    }

    @Test(description="parse simple path")
    public void parseSimplePath() {
        HashMap regexMap = new HashMap();
        String path = PathUtils.parsePath((String)"/api/itemId", regexMap);
        Assert.assertEquals((String)path, (String)"/api/itemId");
        Assert.assertEquals((int)regexMap.size(), (int)0);
    }

    @Test(description="parse path with param without regex")
    public void parsePathWithoutRegex() {
        HashMap regexMap = new HashMap();
        String path = PathUtils.parsePath((String)"/api/{name}", regexMap);
        Assert.assertEquals((String)path, (String)"/api/{name}");
        Assert.assertEquals((int)regexMap.size(), (int)0);
    }

    @Test(description="parse path with two params in one part")
    public void parsePathWithTwoParamsInOnePart() {
        HashMap regexMap = new HashMap();
        String path = PathUtils.parsePath((String)"/{a:\\w+}-{b:\\w+}/c", regexMap);
        Assert.assertEquals((String)path, (String)"/{a}-{b}/c");
        Assert.assertEquals((String)((String)regexMap.get("a")), (String)"\\w+");
        Assert.assertEquals((String)((String)regexMap.get("b")), (String)"\\w+");
    }

    @Test(description="parse path like /swagger.{json|yaml}")
    public void test() {
        HashMap regexMap = new HashMap();
        String path = PathUtils.parsePath((String)"/swagger.{json|yaml}", regexMap);
        Assert.assertEquals((String)path, (String)"/swagger.{json|yaml}");
        Assert.assertEquals((int)regexMap.size(), (int)0);
    }

    @Test(description="parse path with many braces and slashes iside")
    public void parsePathWithBracesAndSlashes() {
        HashMap regexMap = new HashMap();
        String path = PathUtils.parsePath((String)"/api/{regex:/(?!\\{\\})\\w*|/\\{\\w+:*([^\\{\\}]*(\\{.*\\})*)*\\}}", regexMap);
        Assert.assertEquals((String)path, (String)"/api/{regex}");
        Assert.assertEquals((String)((String)regexMap.get("regex")), (String)"/(?!\\{\\})\\w*|/\\{\\w+:*([^\\{\\}]*(\\{.*\\})*)*\\}");
    }

    @Test(description="collect path")
    public void collectPath() {
        String path = PathUtils.collectPath((String[])new String[]{"api", "/users/", "{userId}/"});
        Assert.assertEquals((String)path, (String)"/api/users/{userId}");
    }

    @Test(description="collect path with many slashes inside")
    public void collectPathWithSlashesInside() {
        String path = PathUtils.collectPath((String[])new String[]{"///api/users///", "///getUser///", "/ /"});
        Assert.assertEquals((String)path, (String)"/api/users/getUser");
    }

    @Test(description="not fail when passed path is null")
    public void testNullPath() {
        HashMap regexMap = new HashMap();
        String path = PathUtils.parsePath(null, regexMap);
        Assert.assertEquals((String)path, null);
    }

    @Test(description="not fail when regex is not valid")
    public void testInvalidRegex() {
        HashMap regexMap = new HashMap();
        String path = PathUtils.parsePath((String)"/api/{fail: [a-z]", regexMap);
        Assert.assertEquals((String)path, null);
    }

    @Test(description="not fail when passed path is empty")
    public void testEmptyPath() {
        HashMap regexMap = new HashMap();
        String path = PathUtils.parsePath((String)"", regexMap);
        Assert.assertEquals((String)path, (String)"/");
    }

    @Test(description="not fail when passed path is null")
    public void testNullCollectedPath() {
        String path = PathUtils.collectPath((String[])new String[]{null, null});
        Assert.assertEquals((String)path, (String)"/");
    }

    @Test(description="not fail when passed path is empty")
    public void testEmptyCollectedPath() {
        String path = PathUtils.collectPath((String[])new String[]{""});
        Assert.assertEquals((String)path, (String)"/");
    }
}

