/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.model.override;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.converter.ModelConverters;
import io.swagger.models.Model;
import io.swagger.models.properties.Property;
import io.swagger.util.Json;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CustomConverterTest {
    @Test(description="it should ignore properties with type Bar")
    public void testCustomConverter() {
        ModelConverters converters = new ModelConverters();
        converters.addConverter((ModelConverter)new CustomConverter());
        Model model = (Model)converters.read(Foo.class).get("Foo");
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((int)model.getProperties().size(), (int)1);
        Property barProperty = (Property)model.getProperties().get("bar");
        Assert.assertNull((Object)barProperty);
        Property titleProperty = (Property)model.getProperties().get("title");
        Assert.assertNotNull((Object)titleProperty);
    }

    class Bar {
        public String foo = null;

        Bar() {
        }
    }

    class Foo {
        public Bar bar = null;
        public String title = null;

        Foo() {
        }
    }

    class CustomConverter
    implements ModelConverter {
        CustomConverter() {
        }

        public Property resolveProperty(Type type, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> chain) {
            JavaType jType = Json.mapper().constructType(type);
            if (jType != null) {
                Class cls = jType.getRawClass();
                if (cls.equals(Bar.class)) {
                    return null;
                }
                return chain.next().resolveProperty(type, context, annotations, chain);
            }
            return null;
        }

        public Model resolve(Type type, ModelConverterContext context, Iterator<ModelConverter> chain) {
            return chain.next().resolve(type, context, chain);
        }
    }
}

