/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.model.override;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModel;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverters;
import io.swagger.jackson.ModelResolver;
import io.swagger.jackson.TypeNameResolver;
import io.swagger.models.Model;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.util.Json;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CustomResolverTest {
    @Test(description="it should ignore properties with type Bar")
    public void testCustomConverter() {
        ModelConverters converters = new ModelConverters();
        converters.addConverter((ModelConverter)new CustomConverter(Json.mapper()));
        Map models = converters.readAll(Foo.class);
        Model model = (Model)models.get("io.swagger.model.override.CustomResolverTest$Foo");
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((int)model.getProperties().size(), (int)2);
        RefProperty barProperty = (RefProperty)model.getProperties().get("bar");
        Assert.assertEquals((String)barProperty.get$ref(), (String)"#/definitions/io.swagger.model.override.CustomResolverTest$Bar");
        Property titleProperty = (Property)model.getProperties().get("title");
        Assert.assertNotNull((Object)titleProperty);
        model = (Model)models.get("io.swagger.model.override.CustomResolverTest$Bar");
        Assert.assertNotNull((Object)model);
    }

    class Bar {
        public String foo = null;

        Bar() {
        }
    }

    class Foo {
        public Bar bar = null;
        public String title = null;

        Foo() {
        }
    }

    class QualifiedTypeNameResolver
    extends TypeNameResolver {
        QualifiedTypeNameResolver() {
        }

        protected String nameForClass(Class<?> cls, Set<TypeNameResolver.Options> options) {
            String className;
            String string = className = cls.getName().startsWith("java.") ? cls.getSimpleName() : cls.getName();
            if (options.contains(TypeNameResolver.Options.SKIP_API_MODEL)) {
                return className;
            }
            ApiModel model = cls.getAnnotation(ApiModel.class);
            String modelName = model == null ? null : StringUtils.trimToNull((String)model.value());
            return modelName == null ? className : modelName;
        }
    }

    class CustomConverter
    extends ModelResolver {
        public CustomConverter(ObjectMapper mapper) {
            super(mapper, (TypeNameResolver)new QualifiedTypeNameResolver());
        }
    }
}

