/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtensions;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import io.swagger.util.ParameterProcessor;
import io.swagger.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.ws.rs.core.Context;

public class ReaderUtils {
    public static List<Parameter> collectConstructorParameters(Class<?> cls, Swagger swagger) {
        if (cls.isLocalClass() || cls.isMemberClass() && !Modifier.isStatic(cls.getModifiers())) {
            return Collections.emptyList();
        }
        List<Parameter> selected = Collections.emptyList();
        int maxParamsCount = 0;
        for (Constructor<?> constructor : cls.getDeclaredConstructors()) {
            if (!ReflectionUtils.isConstructorCompatible(constructor) && !ReflectionUtils.isInject(Arrays.asList(constructor.getDeclaredAnnotations()))) continue;
            Type[] genericParameterTypes = constructor.getGenericParameterTypes();
            Annotation[][] annotations = constructor.getParameterAnnotations();
            int paramsCount = 0;
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            for (int i = 0; i < genericParameterTypes.length; ++i) {
                List<Annotation> tmpAnnotations = Arrays.asList(annotations[i]);
                if (ReaderUtils.isContext(tmpAnnotations)) {
                    ++paramsCount;
                    continue;
                }
                Type genericParameterType = genericParameterTypes[i];
                List<Parameter> tmpParameters = ReaderUtils.collectParameters(genericParameterType, tmpAnnotations);
                if (tmpParameters.size() < 1) continue;
                for (Parameter tmpParameter : tmpParameters) {
                    if (ParameterProcessor.applyAnnotations((Swagger)swagger, (Parameter)tmpParameter, (Type)genericParameterType, tmpAnnotations) == null) continue;
                    parameters.add(tmpParameter);
                }
                ++paramsCount;
            }
            if (paramsCount < maxParamsCount) continue;
            maxParamsCount = paramsCount;
            selected = parameters;
        }
        return selected;
    }

    public static List<Parameter> collectFieldParameters(Class<?> cls, Swagger swagger) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Field field : ReflectionUtils.getDeclaredFields(cls)) {
            List<Annotation> annotations = Arrays.asList(field.getAnnotations());
            Type genericType = field.getGenericType();
            for (Parameter parameter : ReaderUtils.collectParameters(genericType, annotations)) {
                if (ParameterProcessor.applyAnnotations((Swagger)swagger, (Parameter)parameter, (Type)genericType, annotations) == null) continue;
                parameters.add(parameter);
            }
        }
        return parameters;
    }

    public static String[] splitContentValues(String[] strings) {
        LinkedHashSet result = new LinkedHashSet();
        for (String string : strings) {
            Iterables.addAll(result, (Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)string));
        }
        return result.toArray(new String[result.size()]);
    }

    private static List<Parameter> collectParameters(Type type, List<Annotation> annotations) {
        Iterator<SwaggerExtension> chain = SwaggerExtensions.chain();
        return chain.hasNext() ? chain.next().extractParameters(annotations, type, new HashSet<Type>(), chain) : Collections.emptyList();
    }

    private static boolean isContext(List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Context)) continue;
            return true;
        }
        return false;
    }
}

