/*
 * Decompiled with CFR 0.152.
 */
package io.takari.graph.dot;

import io.takari.graph.dot.ArrowEnd;
import io.takari.graph.dot.Cluster;
import io.takari.graph.dot.DotUtils;
import io.takari.graph.dot.Graph;
import io.takari.graph.dot.Node;
import io.takari.graph.dot.Point;
import io.takari.graph.dot.Shape;
import io.takari.graph.dot.Spline;
import io.takari.graph.dot.Style;
import io.takari.graph.dot.SubGraph;
import io.takari.graph.dot.SubRecord;
import java.awt.Color;
import java.util.Vector;

public class Edge {
    static final int FORWARD = 0;
    static final int BACK = 1;
    static final int BOTH = 2;
    static final int NONE = 3;
    static final double AUTO_LEN = -1.0;
    private final String[] attributeNames = new String[]{"forward", "back", "both", "none"};
    Style style = new Style();
    int dir;
    int minlen = 1;
    int showboxes = 0;
    Node start = null;
    Node end = null;
    String label = "";
    String URL;
    String fontname = "Times-Roman";
    String labelfontname;
    String tooltip = "";
    String target;
    String samehead = "";
    String sametail = "";
    String penwidth = "";
    Object rootGraph;
    Color[] color;
    Color fontcolor = Color.black;
    Color labelfontcolor;
    boolean constraint = true;
    boolean decorate = false;
    boolean labelfloat = false;
    boolean nojustify = false;
    double fontsize = 14.0;
    double labelangle = -25.0;
    double labeldistance = 1.0;
    double labelfontsize = -1.0;
    double len = -1.0;
    double weight = 1.0;
    ArrowEnd head = new ArrowEnd(new Shape(1), new Shape(0));
    ArrowEnd tail = new ArrowEnd(new Shape(0), new Shape(0));
    double arrowSize;
    Point lp;
    protected SubGraph lhead;
    protected SubGraph ltail;
    Spline pos;
    String[] layer;

    public void addColor(Color edgeColor) {
        if (this.color == null) {
            this.color = new Color[1];
            this.color[0] = edgeColor;
        } else {
            Color[] tmp = new Color[this.color.length + 1];
            System.arraycopy(this.color, 0, tmp, 0, this.color.length);
            tmp[tmp.length - 1] = edgeColor;
            this.color = tmp;
        }
    }

    public void removeColor(Color edgeColor) {
        if (this.color != null) {
            for (int i = this.color.length - 1; i >= this.color.length; --i) {
                if (!this.color[i].equals(edgeColor)) continue;
                Color[] tmp = new Color[this.color.length - 1];
                System.arraycopy(this.color, 0, tmp, 0, i);
                System.arraycopy(this.color, i + 1, tmp, i, this.color.length - i - 1);
                this.color = tmp;
                break;
            }
            if (this.color.length == 0) {
                this.color = null;
            }
        }
    }

    void setStyle(int style, boolean value) {
        this.style.setStyle(style, value);
    }

    boolean getStyle(int s) {
        return this.style.getStyle(s);
    }

    public Edge(Object rootGraph, Node start, Node end) {
        this.rootGraph = rootGraph;
        this.setStart(start);
        this.setEnd(end);
        if (rootGraph instanceof Graph) {
            this.dir = ((Graph)rootGraph).directed ? 0 : 3;
            ((Graph)rootGraph).addEdge(this);
        } else {
            this.dir = ((SubGraph)rootGraph).getRootGraph().directed ? 0 : 3;
            ((SubGraph)rootGraph).addEdge(this);
        }
        this.getGenericAttributes();
    }

    private void getAttributes(Edge edge) {
        if (this.arrowSize != edge.arrowSize) {
            this.arrowSize = edge.arrowSize;
        }
        if (this.color != null) {
            if (!this.color.equals(edge.color)) {
                this.color = edge.color;
            }
        } else {
            this.color = edge.color;
        }
        if (this.constraint != edge.constraint) {
            this.constraint = edge.constraint;
        }
        if (this.decorate != edge.decorate) {
            this.decorate = edge.decorate;
        }
        if (this.dir != edge.dir) {
            this.dir = edge.dir;
        }
        if (this.fontcolor == null) {
            this.fontcolor = edge.fontcolor;
        } else if (!this.fontcolor.equals(edge.fontcolor)) {
            this.fontcolor = edge.fontcolor;
        }
        if (!this.fontname.equals(edge.fontname)) {
            this.fontname = edge.fontname;
        }
        if (this.fontsize != edge.fontsize) {
            this.fontsize = edge.fontsize;
        }
        if (!this.head.equals(edge.head)) {
            this.head = edge.head;
        }
        if (!this.label.equals(edge.label)) {
            this.label = edge.label;
        }
        if (this.labelangle != edge.labelangle) {
            this.labelangle = edge.labelangle;
        }
        if (this.labeldistance != edge.labeldistance) {
            this.labeldistance = edge.labeldistance;
        }
        if (this.labelfloat != edge.labelfloat) {
            this.labelfloat = edge.labelfloat;
        }
        if (this.labelfontcolor == null) {
            this.labelfontcolor = edge.labelfontcolor;
        } else if (!this.labelfontcolor.equals(edge.labelfontcolor)) {
            this.labelfontcolor = edge.labelfontcolor;
        }
        if (this.labelfontname == null) {
            this.labelfontname = edge.labelfontname;
        } else if (!this.labelfontname.equals(edge.labelfontname)) {
            this.labelfontname = edge.labelfontname;
        }
        if (this.labelfontsize != edge.labelfontsize) {
            this.labelfontsize = edge.labelfontsize;
        }
        if (this.layer != null && !this.layer.equals(edge.layer)) {
            this.layer = edge.layer;
        }
        if (this.len != edge.len) {
            this.len = edge.len;
        }
        if (this.lhead != null && !this.lhead.equals(edge.lhead)) {
            this.lhead = edge.lhead;
        }
        if (this.lp != null && !this.lp.equals(edge.lp)) {
            this.lp = edge.lp;
        }
        if (this.ltail != null && !this.ltail.equals(edge.ltail)) {
            this.ltail = edge.ltail;
        }
        if (this.minlen != edge.minlen) {
            this.minlen = edge.minlen;
        }
        if (this.nojustify != edge.nojustify) {
            this.nojustify = edge.nojustify;
        }
        if (this.pos != null && !this.pos.equals(edge.pos)) {
            this.pos = edge.pos;
        }
        if (this.samehead != null && !this.samehead.equals(edge.samehead)) {
            this.samehead = edge.samehead;
        }
        if (this.penwidth != null && !this.penwidth.equals(edge.penwidth)) {
            this.penwidth = edge.penwidth;
        }
        if (this.sametail != null && !this.sametail.equals(edge.sametail)) {
            this.sametail = edge.sametail;
        }
        if (this.showboxes != edge.showboxes) {
            this.showboxes = edge.showboxes;
        }
        if (!this.style.equals(edge.style)) {
            this.style = edge.style;
        }
        if (!this.tail.equals(edge.tail)) {
            this.tail = edge.tail;
        }
        if (this.target != null && !this.target.equals(edge.target)) {
            this.target = edge.target;
        }
        if (this.tooltip != null && !this.tooltip.equals(edge.tooltip)) {
            this.tooltip = edge.tooltip;
        }
        if (this.URL != null && !this.URL.equals(edge.URL)) {
            this.URL = edge.URL;
        }
        if (this.weight != edge.weight) {
            this.weight = edge.weight;
        }
    }

    private void getGenericAttributes() {
        Object root = this.rootGraph;
        Vector<Object> roots = new Vector<Object>();
        while (root instanceof SubGraph) {
            roots.add(root);
            root = ((SubGraph)root).root;
        }
        if (((Graph)root).genericEdge != null) {
            this.getAttributes(((Graph)root).genericEdge);
        }
        for (int i = roots.size() - 1; i == 0; --i) {
            Edge generic = ((SubGraph)roots.get((int)i)).genericEdge;
            if (generic == null) continue;
            this.getAttributes(generic);
        }
    }

    public void setStart(Node start) {
        if (this.start != null) {
            this.start.removeInEdge(this);
        }
        this.start = start;
        this.start.addInEdge(this);
    }

    public void setEnd(Node end) {
        if (this.end != null) {
            this.end.removeOutEdge(this);
        }
        this.end = end;
        this.end.addOutEdge(this);
    }

    public Node getStart() {
        return this.start;
    }

    public Node getEnd() {
        return this.end;
    }

    public void changeOption(String name, String value) {
        String v = value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"' ? value.substring(1, value.length() - 1) : value;
        v = v.replaceAll("\\\\\\n", "");
        if (!name.equals("arrowhead") && !name.equals("arrowtail")) {
            if (name.equals("arrowsize")) {
                this.arrowSize = DotUtils.readDouble(v);
            } else if (name.equals("color")) {
                Color[] colors = DotUtils.readColors(v);
                for (int i = 0; i < colors.length; ++i) {
                    this.addColor(colors[i]);
                }
            } else if (name.equals("constraint")) {
                this.constraint = DotUtils.readBoolean(v);
            } else if (name.equals("decorate")) {
                this.decorate = DotUtils.readBoolean(v);
            } else if (name.equals("dir")) {
                this.dir = DotUtils.readInteger(v);
            } else if (name.equals("fontcolor")) {
                this.fontcolor = DotUtils.readColor(v);
            } else if (name.equals("fontname")) {
                this.fontname = v;
            } else if (name.equals("fontsize")) {
                this.fontsize = DotUtils.readDouble(v);
            } else if (name.equals("label")) {
                this.label = v;
            } else if (name.equals("labelangle")) {
                this.labelangle = DotUtils.readDouble(v);
            } else if (name.equals("labeldistance")) {
                this.labeldistance = DotUtils.readDouble(v);
            } else if (name.equals("labelfloat")) {
                this.labelfloat = DotUtils.readBoolean(v);
            } else if (name.equals("labelfontcolor")) {
                this.labelfontcolor = DotUtils.readColor(v);
            } else if (name.equals("labelfontname")) {
                this.labelfontname = v;
            } else if (name.equals("labelfontsize")) {
                this.labelfontsize = DotUtils.readDouble(v);
            } else if (name.equals("layer")) {
                this.layer = v.split(" ");
            } else if (name.equals("len")) {
                double d = DotUtils.readDouble(v);
                this.len = d <= 0.0 ? -1.0 : d;
            } else if (name.equals("lp")) {
                this.lp = DotUtils.readPoint(v);
            } else if (name.equals("minlen")) {
                this.minlen = DotUtils.readInteger(v);
            } else if (name.equals("nojustify")) {
                this.nojustify = DotUtils.readBoolean(v);
            } else if (name.equals("pos")) {
                this.pos = DotUtils.readSpline(v);
            } else if (name.equals("samehead")) {
                this.samehead = v;
            } else if (name.equals("sametail")) {
                this.sametail = v;
            } else if (name.equals("penwidth")) {
                this.penwidth = v;
            } else if (name.equals("showboxes")) {
                this.showboxes = DotUtils.readInteger(v);
            } else if (name.equals("style")) {
                DotUtils.readStyle(this.style, v);
            } else if (name.equals("target")) {
                this.target = v;
            } else if (name.equals("tooltip")) {
                this.tooltip = v;
            } else if (name.equals("URL") || name.equals("href")) {
                this.URL = v;
            } else if (name.equals("weight")) {
                this.weight = DotUtils.readDouble(v);
            } else if (name.equals("headport")) {
                this.head.port = this.readAttributeNumber(v);
            } else if (name.equals("tailport")) {
                this.tail.port = this.readAttributeNumber(v);
            } else {
                System.err.println("Edge attribute \"" + name + "\" does not exist");
            }
        }
    }

    private int readAttributeNumber(String v) {
        for (int i = 0; i < this.attributeNames.length; ++i) {
            if (!this.attributeNames[i].equalsIgnoreCase(v)) continue;
            return i;
        }
        System.err.println("Edge value \"" + v + "\" does not exist");
        return -1;
    }

    public String toString() {
        String e = "";
        if (this.start instanceof SubRecord) {
            e = ((SubRecord)this.start).rootRecord.id + ":";
        }
        e = e + (this.start instanceof Cluster ? "cluster" : "") + this.start.id;
        e = e + this.tail;
        e = e + (this.getRootGraph().directed ? " -> " : " -- ");
        if (this.end instanceof SubRecord) {
            e = e + ((SubRecord)this.end).rootRecord.id + ":";
        }
        e = e + (this.end instanceof Cluster ? "cluster" : "") + this.end.id;
        e = e + this.head;
        String o = this.edgeOptions();
        if (!o.equals(" ")) {
            e = e + " [" + o + "]";
        }
        return e + ";\n";
    }

    private String edgeOptions() {
        String o = " ";
        if (this.color != null) {
            o = o + this.printOption("color", this.color);
        }
        if (!this.constraint) {
            o = o + this.printOption("constraint", this.constraint);
        }
        if (this.decorate) {
            o = o + this.printOption("decorate", this.decorate);
        }
        Graph root = this.getRootGraph();
        if (root.directed && this.dir != 0 || !root.directed && this.dir != 3) {
            o = o + this.printNamedOption("dir", this.dir);
        }
        if (!this.fontcolor.equals(Color.black)) {
            o = o + this.printOption("fontcolor", this.fontcolor);
        }
        if (!this.fontname.equals("Times-Roman")) {
            o = o + this.printOption("fontname", this.fontname);
        }
        if (this.fontsize != 14.0) {
            o = o + this.printOption("fontsize", this.fontsize);
        }
        if (this.head != null) {
            o = o + this.printOption("head", this.head);
        }
        if (this.tail != null) {
            o = o + this.printOption("tail", this.tail);
        }
        if (!this.label.equals("")) {
            o = o + this.printOption("label", this.label);
        }
        if (this.labelangle != -25.0) {
            o = o + this.printOption("labelangle", this.labelangle);
        }
        if (this.labeldistance != 1.0) {
            o = o + this.printOption("labeldistance", this.labeldistance);
        }
        if (this.labelfloat) {
            o = o + this.printOption("labelfloat", this.labelfloat);
        }
        if (this.labelfontcolor != null) {
            o = o + this.printOption("labelfontcolor", this.labelfontcolor);
        }
        if (this.labelfontname != null) {
            o = o + this.printOption("labelfontname", this.labelfontname);
        }
        if (this.labelfontsize != -1.0 && this.labelfontsize != 11.0) {
            o = o + this.printOption("labelfontsize", this.labelfontsize);
        }
        if (this.layer != null) {
            o = o + this.printOption("layer", this.layer);
        }
        if (this.len != -1.0) {
            o = o + this.printOption("len", this.len);
        }
        if (this.lhead != null) {
            o = o + this.printOption("lhead", this.lhead);
        }
        if (this.ltail != null) {
            o = o + this.printOption("ltail", this.ltail);
        }
        if (this.lp != null) {
            o = o + this.printOption("lp", this.lp);
        }
        if (this.minlen != 1) {
            o = o + this.printOption("minlen", this.minlen);
        }
        if (this.nojustify) {
            o = o + this.printOption("nojustify", this.nojustify);
        }
        if (this.pos != null) {
            o = o + this.printOption("pos", this.pos);
        }
        if (!this.samehead.equals("")) {
            o = o + this.printOption("samehead", this.samehead);
        }
        if (!this.penwidth.equals("")) {
            o = o + this.printOption("penwidth", this.penwidth);
        }
        if (!this.sametail.equals("")) {
            o = o + this.printOption("sametail", this.sametail);
        }
        if (this.showboxes != 0) {
            o = o + this.printOption("showboxes", this.showboxes);
        }
        o = o + this.printOption("style", this.style);
        if (this.target != null) {
            o = o + this.printOption("target", this.target);
        }
        if (!this.tooltip.equals("")) {
            o = o + this.printOption("tooltip", this.tooltip);
        }
        if (this.URL != null) {
            o = o + this.printOption("URL", this.URL);
        }
        if (this.weight != 1.0) {
            o = o + this.printOption("weight", this.weight);
        }
        return o;
    }

    private String printOption(String attribute, Style value) {
        String o = value.toString();
        if (o.equals("")) {
            return "";
        }
        return attribute + "=" + value + " ";
    }

    private String printOption(String attribute, boolean value) {
        return attribute + "=\"" + value + "\" ";
    }

    private String printOption(String attribute, Color[] value) {
        String o = "";
        for (int i = 0; i < value.length; ++i) {
            if (i > 0) {
                o = o + ":";
            }
            o = o + this.printColor(value[i]);
        }
        return attribute + "=\"" + o + "\" ";
    }

    private String printOption(String attribute, Color value) {
        return attribute + "=\"" + this.printColor(value) + "\" ";
    }

    private String printOption(String attribute, double value) {
        return attribute + "=" + value + " ";
    }

    private String printOption(String attribute, int value) {
        return attribute + "=" + value + " ";
    }

    private String printOption(String attribute, String value) {
        return attribute + "=\"" + value + "\" ";
    }

    private String printOption(String attribute, String[] value) {
        String ret = attribute + "=\"";
        for (int i = 0; i < value.length; ++i) {
            if (i > 0) {
                ret = ret + " ";
            }
            ret = ret + value[i];
        }
        return ret + "\" ";
    }

    private String printOption(String attribute, ArrowEnd value) {
        return value.printArrowEndOptions(attribute);
    }

    private String printOption(String attribute, Point value) {
        String o = attribute + "=\"";
        for (int i = 0; i < value.coords.length; ++i) {
            if (i > 0) {
                o = o + ",";
            }
            o = o + value.coords[i];
        }
        return o + "\"" + (value.change ? "" : "!") + " ";
    }

    private String printOption(String attribute, SubGraph value) {
        return attribute + "=\"" + value.id + "\" ";
    }

    private String printOption(String attribute, Spline value) {
        String o = attribute + "=\"";
        return o + value + "\" ";
    }

    private String printColor(Color value) {
        String r = Integer.toHexString(value.getRed());
        String g = Integer.toHexString(value.getGreen());
        String b = Integer.toHexString(value.getBlue());
        String a = Integer.toHexString(value.getAlpha());
        if (r.length() == 1) {
            r = "0" + r;
        }
        if (g.length() == 1) {
            g = "0" + g;
        }
        if (b.length() == 1) {
            b = "0" + b;
        }
        if (a.length() == 1) {
            a = "0" + a;
        }
        return "#" + r + g + b + a;
    }

    private String printNamedOption(String attribute, int i) {
        return attribute + "=\"" + this.attributeNames[i] + "\" ";
    }

    private Graph getRootGraph() {
        if (this.rootGraph instanceof Graph) {
            return (Graph)this.rootGraph;
        }
        return ((SubGraph)this.rootGraph).getRootGraph();
    }
}

