/*
 * Decompiled with CFR 0.152.
 */
package io.takari.graph.dot;

import io.takari.graph.dot.CommonNode;
import io.takari.graph.dot.DotUtils;
import io.takari.graph.dot.Graph;
import io.takari.graph.dot.Rectangle;
import io.takari.graph.dot.SubGraph;
import io.takari.graph.dot.SubRecord;
import java.util.Vector;

class Record
extends CommonNode {
    Record rootRecord;
    Rectangle[] rects;
    protected SubRecord[] subRecords;

    public Record(Object root, String id) throws Exception {
        super(root, id);
        if (!(this instanceof SubRecord)) {
            this.label = id;
            this.rootRecord = this;
        }
        this.getGenericAttributes();
    }

    private void getAttributes(Record record) {
        if (this.rects != null && record.rects != null && this.rects.equals(record.rects)) {
            this.rects = record.rects;
        }
        if (this.isRounded() != record.isRounded()) {
            this.setRounded(record.isRounded());
        }
        if (this.fixedsize != record.fixedsize) {
            this.fixedsize = record.fixedsize;
        }
        if (!this.group.equals(record.group)) {
            this.group = record.group;
        }
        if (this.height != record.height) {
            this.height = record.height;
        }
        if (this.layer != null && record.layer != null && !this.layer.equals(record.layer)) {
            this.layer = record.layer;
        }
        if (!this.margin.equals(record.margin)) {
            this.margin = record.margin;
        }
        if (this.pin != record.pin) {
            this.pin = record.pin;
        }
        if (this.pos != null && record.pos != null && !this.pos.equals(record.pos)) {
            this.pos = record.pos;
        }
        if (this.rotate != record.rotate) {
            this.rotate = record.rotate;
        }
        if (this.showboxes != record.showboxes) {
            this.showboxes = record.showboxes;
        }
        if (!this.tooltip.equals(record.tooltip)) {
            this.tooltip = record.tooltip;
        }
        if (this.vertices != null && record.vertices != null && !this.vertices.equals(record.vertices)) {
            this.vertices = record.vertices;
        }
        if (this.width != record.width) {
            this.width = record.width;
        }
        if (this.z != record.z) {
            this.z = record.z;
        }
        if (this.color == null) {
            this.color = record.color;
        } else if (!this.color.equals(record.color)) {
            this.color = record.color;
        }
        if (this.fillcolor == null) {
            this.fillcolor = record.fillcolor;
        } else if (!this.fillcolor.equals(record.fillcolor)) {
            this.fillcolor = record.fillcolor;
        }
        if (this.fontcolor == null) {
            this.fontcolor = record.fontcolor;
        } else if (!this.fontcolor.equals(record.fontcolor)) {
            this.fontcolor = record.fontcolor;
        }
        if (!this.fontname.equals(record.fontname)) {
            this.fontname = record.fontname;
        }
        if (this.fontsize != record.fontsize) {
            this.fontsize = record.fontsize;
        }
        if (this.label != null && record.label != null && !this.label.equals(record.label) && !record.label.equals("node")) {
            this.label = record.label;
        }
        if (this.nojustify != record.nojustify) {
            this.nojustify = record.nojustify;
        }
        if (this.peripheries != record.peripheries) {
            this.peripheries = record.peripheries;
        }
        if (!this.style.equals(record.style)) {
            this.style = record.style;
        }
        if (this.target != null && record.target != null && !this.target.equals(record.target)) {
            this.target = record.target;
        }
        if (this.URL != null && record.URL != null && !this.URL.equals(record.URL)) {
            this.URL = record.URL;
        }
    }

    private void getGenericAttributes() {
        Object rootGraph = this.root;
        Vector<Object> roots = new Vector<Object>();
        while (rootGraph instanceof SubGraph) {
            roots.add(rootGraph);
            rootGraph = ((SubGraph)rootGraph).root;
        }
        if (((Graph)rootGraph).genericRecord != null) {
            this.getAttributes(((Graph)rootGraph).genericRecord);
        }
        for (int i = roots.size() - 1; i == 0; --i) {
            Record generic = ((SubGraph)roots.get((int)i)).genericRecord;
            if (generic == null) continue;
            this.getAttributes(generic);
        }
    }

    public void addSubRecord(SubRecord subRecord) {
        if (this.subRecords == null) {
            this.subRecords = new SubRecord[1];
            this.subRecords[0] = subRecord;
        } else {
            SubRecord[] tmp = new SubRecord[this.subRecords.length + 1];
            System.arraycopy(this.subRecords, 0, tmp, 0, this.subRecords.length);
            tmp[tmp.length - 1] = subRecord;
            this.subRecords = tmp;
        }
    }

    public void addRectangle(Rectangle rect) {
        if (this.rects == null) {
            this.rects = new Rectangle[1];
            this.rects[0] = rect;
        } else {
            Rectangle[] tmp = new Rectangle[this.rects.length + 1];
            System.arraycopy(this.rects, 0, tmp, 0, this.rects.length);
            tmp[tmp.length - 1] = rect;
            this.rects = tmp;
        }
    }

    public void removeSubRecord(SubRecord subRecord) {
        if (this.subRecords != null) {
            for (int i = 0; i < this.subRecords.length; ++i) {
                if (this.subRecords[i] != subRecord) continue;
                SubRecord[] tmp = new SubRecord[this.subRecords.length - 1];
                System.arraycopy(this.subRecords, 0, tmp, 0, i);
                System.arraycopy(this.subRecords, i + 1, tmp, i, this.subRecords.length - i - 1);
                this.subRecords = tmp;
                break;
            }
            if (this.subRecords.length == 0) {
                this.subRecords = null;
            }
        }
    }

    public void removeRectangle(Rectangle rect) {
        if (this.rects != null) {
            for (int i = 0; i < this.rects.length; ++i) {
                if (this.rects[i] != rect) continue;
                Rectangle[] tmp = new Rectangle[this.rects.length - 1];
                System.arraycopy(this.rects, 0, tmp, 0, i);
                System.arraycopy(this.rects, i + 1, tmp, i, this.rects.length - i - 1);
                this.rects = tmp;
                break;
            }
            if (this.rects.length == 0) {
                this.rects = null;
            }
        }
    }

    public boolean isRounded() {
        return this.style.getStyle(7);
    }

    public void setRounded(boolean rounded) {
        this.style.setStyle(7, rounded);
    }

    @Override
    protected void changeOption(String name, String value) {
        try {
            super.changeOption(name, value);
        }
        catch (Exception e) {
            String v = value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"' ? value.substring(1, value.length() - 1) : value;
            v = v.replaceAll("\\\\\\n", "");
            if (name.equals("rects")) {
                this.rects = DotUtils.readRectangleList(v);
            }
            if (name.equals("shape")) {
                DotUtils.readShape(this, v);
            }
            System.err.println("Record attribute \"" + name + "\" does not exist");
        }
    }

    @Override
    public String toString() {
        return this.id + " [" + this.nodeOptions() + "];\n";
    }

    @Override
    protected String nodeOptions() {
        String o = super.nodeOptions();
        o = o + this.printShapeOption();
        String recordLabel = this.printRecordLabel();
        if (!recordLabel.equals("")) {
            o = o + "label=\"" + recordLabel + "\" ";
        }
        if (this.rects != null) {
            o = o + this.printOption("rects", this.rects);
        }
        return o;
    }

    private String printOption(String attribute, Rectangle[] value) {
        String s = "";
        for (int i = 0; i < value.length; ++i) {
            if (i > 0) {
                s = s + " ";
            }
            s = s + value[i];
        }
        return attribute + "=\"" + s + "\" ";
    }

    protected String printShapeOption() {
        return "shape=\"" + (this.isRounded() ? "M" : "") + "record\" ";
    }

    protected String printRecordLabel() {
        String l = "";
        if (this.subRecords != null) {
            for (int i = 0; i < this.subRecords.length; ++i) {
                if (i > 0) {
                    l = l + " | ";
                }
                if (!this.subRecords[i].id.equals("")) {
                    l = l + "<" + this.subRecords[i].id + ">";
                }
                if (this.subRecords[i].label != null) {
                    l = l + " " + this.subRecords[i].label.trim();
                }
                if (this.subRecords[i].subRecords == null) continue;
                l = l + "{ " + this.subRecords[i].printRecordLabel() + " }";
            }
        }
        return l;
    }
}

