/*
 * Decompiled with CFR 0.152.
 */
package io.takari.graph.tinkerpop;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.tg.TinkerGraph;
import io.takari.graph.Dependency;
import io.takari.graph.DependencyGraph;
import io.takari.graph.render.D3GraphRenderer;
import io.takari.graph.render.DotGraphRenderer;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;

public class TinkerPopDependencyGraph<V>
implements DependencyGraph<V> {
    private static final String DATA = "@data@";
    private static final String ROOT = "@root@";
    private final Graph graph = new TinkerGraph();

    public TinkerPopDependencyGraph(V root) {
        Vertex rootVertex = this.graph.addVertex((Object)ROOT);
        rootVertex.setProperty(DATA, root);
    }

    @Override
    public V getRoot() {
        return (V)this.graph.getVertex((Object)ROOT).getProperty(DATA);
    }

    @Override
    public Iterable<V> getDependencyNodes() {
        return Iterables.transform((Iterable)this.graph.getVertices(), (Function)new Function<Vertex, V>(){

            public V apply(Vertex vertex) {
                return vertex.getProperty(TinkerPopDependencyGraph.DATA);
            }
        });
    }

    @Override
    public Dependency<V> addDependency(V source, V target) {
        Vertex tv;
        Vertex sv = this.graph.getVertex(source);
        if (sv == null) {
            sv = this.graph.addVertex(source);
            sv.setProperty(DATA, source);
        }
        if ((tv = this.graph.getVertex(target)) == null) {
            tv = this.graph.addVertex(target);
            tv.setProperty(DATA, target);
        }
        Edge edge = this.graph.addEdge(null, sv, tv, "");
        Dependency<V> dependency = new Dependency<V>(source, target);
        edge.setProperty(DATA, dependency);
        return dependency;
    }

    @Override
    public Iterable<Dependency<V>> getDependencies() {
        return Iterables.transform((Iterable)this.graph.getEdges(), (Function)new Function<Edge, Dependency<V>>(){

            public Dependency<V> apply(Edge edge) {
                return (Dependency)edge.getProperty(TinkerPopDependencyGraph.DATA);
            }
        });
    }

    @Override
    public List<V> getDirectUpstream(V v) {
        Iterable upstream = this.graph.getVertex(v).getVertices(Direction.OUT, new String[0]);
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)upstream, (Function)new Function<Vertex, V>(){

            public V apply(Vertex vertex) {
                return vertex.getProperty(TinkerPopDependencyGraph.DATA);
            }
        }));
    }

    @Override
    public List<V> getTransitiveUpstream(V v) {
        ArrayList upstream = Lists.newArrayList();
        Vertex vertex = this.graph.getVertex(v);
        this.collectVertices(vertex, Direction.OUT, upstream);
        return Lists.transform((List)upstream, (Function)new Function<Vertex, V>(){

            public V apply(Vertex vertex) {
                return vertex.getProperty(TinkerPopDependencyGraph.DATA);
            }
        });
    }

    public List<V> getDirectDownstream(V v) {
        Iterable downstream = this.graph.getVertex(v).getVertices(Direction.IN, new String[0]);
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)downstream, (Function)new Function<Vertex, V>(){

            public V apply(Vertex vertex) {
                return vertex.getProperty(TinkerPopDependencyGraph.DATA);
            }
        }));
    }

    public List<Vertex> getDownstreamTransitive(Vertex v) {
        ArrayList downstream = Lists.newArrayList();
        this.collectVertices(v, Direction.IN, downstream);
        return downstream;
    }

    private void collectVertices(Vertex vertex, Direction direction, List<Vertex> vertices) {
        for (Vertex v : vertex.getVertices(direction, new String[0])) {
            vertices.add(v);
            this.collectVertices(v, direction, vertices);
        }
    }

    public static void main(String[] args) throws Exception {
        TinkerPopDependencyGraph<String> g = new TinkerPopDependencyGraph<String>("root");
        g.addDependency("root", "a");
        g.addDependency("root", "b");
        g.addDependency("root", "c");
        g.addDependency("root", "d");
        g.addDependency("a", "one");
        g.addDependency("a", "two");
        g.addDependency("b", "one");
        g.addDependency("b", "two");
        g.addDependency("c", "one");
        g.addDependency("c", "two");
        g.addDependency("d", "one");
        g.addDependency("d", "two");
        g.addDependency("d", "three");
        DotGraphRenderer<String> dot = new DotGraphRenderer<String>();
        dot.render(g, System.out);
        System.out.println();
        D3GraphRenderer<String> d3 = new D3GraphRenderer<String>();
        FileOutputStream os = new FileOutputStream(new File("/Users/jvanzyl/js/tesla/tesla-graph/src/main/webapp/maven.json"));
        d3.render(g, os);
    }
}

