/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.js.templates.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import io.undertow.js.templates.Template;
import io.undertow.js.templates.TemplateProvider;
import io.undertow.js.templates.Templates;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FreemarkerTemplateProvider
implements TemplateProvider {
    private volatile Configuration cfg;
    private volatile ResourceManager resourceManager;
    private final Map<String, String> templates = Collections.synchronizedMap(new HashMap());

    public String name() {
        return "freemarker";
    }

    public void init(Map<String, String> properties, ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        boolean debug = Boolean.parseBoolean(properties.get("debug"));
        this.templates.clear();
        this.cfg = new Configuration(Configuration.VERSION_2_3_22);
        this.cfg.setDefaultEncoding(properties.containsKey("charset") ? properties.get("charset") : "UTF-8");
        this.cfg.setTemplateExceptionHandler(debug ? TemplateExceptionHandler.DEBUG_HANDLER : TemplateExceptionHandler.RETHROW_HANDLER);
        this.cfg.setTemplateLoader(new TemplateLoader(){

            public Object findTemplateSource(String name) throws IOException {
                if (!FreemarkerTemplateProvider.this.templates.containsKey(name)) {
                    return null;
                }
                return name;
            }

            public long getLastModified(Object templateSource) {
                return 0L;
            }

            public Reader getReader(Object templateSource, String encoding) throws IOException {
                return new StringReader((String)FreemarkerTemplateProvider.this.templates.get(templateSource));
            }

            public void closeTemplateSource(Object templateSource) throws IOException {
            }
        });
    }

    public Template getTemplate(String templateName) {
        try {
            this.templates.put(templateName, Templates.loadTemplate((String)templateName, (ResourceManager)this.resourceManager));
            final freemarker.template.Template temp = this.cfg.getTemplate(templateName);
            return new Template(){

                public String apply(Object data) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    try {
                        temp.process(data, (Writer)new OutputStreamWriter(out));
                        return new String(out.toByteArray(), FreemarkerTemplateProvider.this.cfg.getDefaultEncoding());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

