/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.security.AccessController;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logmanager.JBossLoggerFinder;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;

public class JBossLoggerFinder
extends System.LoggerFinder {
    private static final Map<System.Logger.Level, java.util.logging.Level> LEVELS = new EnumMap(System.Logger.Level.class);
    private static final AtomicBoolean LOGGED = new AtomicBoolean(false);
    private static volatile boolean PROPERTY_SET = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public System.Logger getLogger(String name, Module module) {
        java.util.logging.Logger logger2;
        if (!PROPERTY_SET) {
            JBossLoggerFinder jBossLoggerFinder = this;
            synchronized (jBossLoggerFinder) {
                if (!PROPERTY_SET) {
                    if (System.getSecurityManager() == null) {
                        if (System.getProperty("java.util.logging.manager") == null) {
                            System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
                        }
                    } else {
                        AccessController.doPrivileged(() -> {
                            if (System.getProperty("java.util.logging.manager") == null) {
                                System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
                            }
                            return null;
                        });
                    }
                }
                PROPERTY_SET = true;
            }
        }
        if (!((logger2 = java.util.logging.Logger.getLogger(name)) instanceof Logger) && LOGGED.compareAndSet(false, true)) {
            logger2.log((java.util.logging.Level)Level.ERROR, "The LogManager accessed before the \"java.util.logging.manager\" system property was set to \"org.jboss.logmanager.LogManager\". Results may be unexpected.");
        }
        return new JBossSystemLogger(logger2, null);
    }

    static /* synthetic */ Map access$100() {
        return LEVELS;
    }

    static {
        LEVELS.put(System.Logger.Level.ALL, Level.ALL);
        LEVELS.put(System.Logger.Level.TRACE, Level.TRACE);
        LEVELS.put(System.Logger.Level.DEBUG, Level.DEBUG);
        LEVELS.put(System.Logger.Level.INFO, Level.INFO);
        LEVELS.put(System.Logger.Level.WARNING, Level.WARN);
        LEVELS.put(System.Logger.Level.ERROR, Level.ERROR);
        LEVELS.put(System.Logger.Level.OFF, Level.OFF);
    }
}

