/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results.format;

import java.io.PrintStream;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.results.format.ResultFormat;

class XSVResultFormat
implements ResultFormat {
    private final PrintStream out;
    private final String delimiter;

    public XSVResultFormat(PrintStream out, String delimiter) {
        this.out = out;
        this.delimiter = delimiter;
    }

    @Override
    public void writeOut(Collection<RunResult> results) {
        TreeSet<String> params = new TreeSet<String>();
        for (RunResult res : results) {
            params.addAll(res.getParams().getParamsKeys());
        }
        this.printHeader(params);
        for (RunResult rr : results) {
            BenchmarkParams benchParams = rr.getParams();
            Result res = rr.getPrimaryResult();
            this.printLine(benchParams.getBenchmark(), benchParams, params, res);
            for (String label : rr.getSecondaryResults().keySet()) {
                Result subRes = rr.getSecondaryResults().get(label);
                this.printLine(benchParams.getBenchmark() + ":" + subRes.getLabel(), benchParams, params, subRes);
            }
        }
    }

    private void printHeader(SortedSet<String> params) {
        this.out.print("\"Benchmark\"");
        this.out.print(this.delimiter);
        this.out.print("\"Mode\"");
        this.out.print(this.delimiter);
        this.out.print("\"Threads\"");
        this.out.print(this.delimiter);
        this.out.print("\"Samples\"");
        this.out.print(this.delimiter);
        this.out.print("\"Score\"");
        this.out.print(this.delimiter);
        this.out.printf("\"Score Error (%.1f%%)\"", 99.9);
        this.out.print(this.delimiter);
        this.out.print("\"Unit\"");
        for (String k : params) {
            this.out.print(this.delimiter);
            this.out.print("\"Param: " + k + "\"");
        }
        this.out.print("\r\n");
    }

    private void printLine(String label, BenchmarkParams benchmarkParams, SortedSet<String> params, Result result) {
        this.out.print("\"");
        this.out.print(label);
        this.out.print("\"");
        this.out.print(this.delimiter);
        this.out.print("\"");
        this.out.print(benchmarkParams.getMode().shortLabel());
        this.out.print("\"");
        this.out.print(this.delimiter);
        this.out.print(this.emit(benchmarkParams.getThreads()));
        this.out.print(this.delimiter);
        this.out.print(this.emit(result.getSampleCount()));
        this.out.print(this.delimiter);
        this.out.print(this.emit(result.getScore()));
        this.out.print(this.delimiter);
        this.out.print(this.emit(result.getScoreError()));
        this.out.print(this.delimiter);
        this.out.print("\"");
        this.out.print(result.getScoreUnit());
        this.out.print("\"");
        for (String p : params) {
            this.out.print(this.delimiter);
            String v = benchmarkParams.getParam(p);
            if (v == null) continue;
            this.out.print(this.emit(v));
        }
        this.out.print("\r\n");
    }

    private String emit(String v) {
        if (v.contains(this.delimiter) || v.contains(" ") || v.contains("\n") || v.contains("\r") || v.contains("\"")) {
            return "\"" + v.replaceAll("\"", "\"\"") + "\"";
        }
        return v;
    }

    private String emit(int i) {
        return this.emit(String.format("%d", i));
    }

    private String emit(long l) {
        return this.emit(String.format("%d", l));
    }

    private String emit(double d) {
        return this.emit(String.format("%f", d));
    }
}

