/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.benchmarks;

import io.undertow.benchmarks.BenchmarkUtils;
import io.undertow.benchmarks.SimpleBenchmarkState;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.InputStreamEntity;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Measurement(iterations=3, time=3)
@Warmup(iterations=3, time=3)
@Fork(value=1)
@Threads(value=32)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
public class SimpleBenchmarks {
    @Benchmark
    public void benchmarkBlockingEmptyGet(SimpleBenchmarkState state) throws IOException {
        try (CloseableHttpResponse response = state.client().execute(new HttpGet(state.getBaseUri() + "/blocking?size=0"));){
            this.validateLength(response, 0L);
        }
    }

    @Benchmark
    public void benchmarkBlockingLargeGet(SimpleBenchmarkState state) throws IOException {
        try (CloseableHttpResponse response = state.client().execute(new HttpGet(state.getBaseUri() + "/blocking?size=256000"));){
            this.validateLength(response, 256000L);
        }
    }

    @Benchmark
    public void benchmarkBlockingEmptyPost(SimpleBenchmarkState state) throws IOException {
        try (CloseableHttpResponse response = state.client().execute(new HttpPost(state.getBaseUri() + "/blocking"));){
            String result = this.asString(this.validate(response).getEntity());
            if (!"0".equals(result)) {
                throw new IllegalStateException("expected 0, was " + result);
            }
        }
    }

    @Benchmark
    public void benchmarkBlockingLargePost(SimpleBenchmarkState state) throws IOException {
        HttpPost post = new HttpPost(state.getBaseUri() + "/blocking");
        post.setEntity(new InputStreamEntity(new StubInputStream(256000)));
        try (CloseableHttpResponse response = state.client().execute(post);){
            String result = this.asString(this.validate(response).getEntity());
            if (!"256000".equals(result)) {
                throw new IllegalStateException("expected 256000, was " + result);
            }
        }
    }

    private String asString(HttpEntity entity) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        entity.writeTo(baos);
        return baos.toString("UTF-8");
    }

    private void validateLength(HttpResponse response, long expectedLength) throws IOException {
        long length = BenchmarkUtils.length(this.validate(response).getEntity().getContent());
        if (length != expectedLength) {
            throw new IllegalStateException("Unexpected length " + length);
        }
    }

    private <T extends HttpResponse> T validate(T response) {
        int status = response.getStatusLine().getStatusCode();
        if (status != 200) {
            throw new IllegalStateException("Unexpected status code " + status);
        }
        return response;
    }

    private static final class StubInputStream
    extends InputStream {
        private int bytes;

        StubInputStream(int bytes) {
            this.bytes = bytes;
        }

        @Override
        public int read() {
            if (this.bytes <= 0) {
                return -1;
            }
            --this.bytes;
            return 1;
        }

        @Override
        public int available() {
            return this.bytes;
        }
    }
}

