/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.benchmarks;

import io.undertow.benchmarks.AsciiEncoders;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.SplittableRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Measurement(iterations=10, time=200, timeUnit=TimeUnit.MILLISECONDS)
@Warmup(iterations=10, time=200, timeUnit=TimeUnit.MILLISECONDS)
@Fork(value=2)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
public class AsciiEncodingBenchmark
implements AsciiEncoders.BufferFlusher {
    private static final int ASCII_GEN_SEED = 0;
    @Param(value={"7", "19", "248", "12392", "493727"})
    private int inLength;
    @Param(value={"8196"})
    private int outCapacity;
    @Param(value={"batch", "noBatch", "vanilla"})
    private String encoderType;
    private ByteBuffer out;
    private char[] input;
    private AsciiEncoders.AsciiEncoder encoder;

    @Setup
    public void init() {
        this.out = ByteBuffer.allocateDirect(this.outCapacity).order(ByteOrder.BIG_ENDIAN);
        SplittableRandom random = new SplittableRandom(0L);
        this.input = new char[this.inLength];
        for (int i = 0; i < this.inLength; ++i) {
            this.input[i] = (char)random.nextInt(0, 128);
        }
        switch (this.encoderType) {
            case "batch": {
                this.encoder = AsciiEncoders.BatchFixedBufferOffsetAsciiEncoder.Instance;
                break;
            }
            case "noBatch": {
                this.encoder = AsciiEncoders.NonBatchFixedBufferOffsetAsciiEncoder.Instance;
                break;
            }
            case "vanilla": {
                this.encoder = AsciiEncoders.NonBatchMutableBufferOffsetAsciiEncoder.Instance;
            }
        }
    }

    @Override
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public void flushBuffer(ByteBuffer buffer) throws IOException {
        buffer.position(0);
    }

    @Benchmark
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public int encode() throws IOException {
        ByteBuffer out = this.out;
        char[] input = this.input;
        out.clear();
        return this.encoder.writeAndFlushAscii(this, out, this.input, 0, input.length);
    }
}

