/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.benchmarks;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

final class TLSUtils {
    private static final String SERVER_KEY_STORE = "server.keystore";
    private static final String SERVER_TRUST_STORE = "server.truststore";
    private static final String CLIENT_KEY_STORE = "client.keystore";
    private static final String CLIENT_TRUST_STORE = "client.truststore";
    private static final char[] STORE_PASSWORD = "password".toCharArray();

    static SSLContext newServerContext() {
        try {
            KeyStore keyStore = TLSUtils.loadKeyStore(SERVER_KEY_STORE);
            KeyStore trustStore = TLSUtils.loadKeyStore(SERVER_TRUST_STORE);
            return TLSUtils.createSSLContext(keyStore, trustStore);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create server SSLContext", e);
        }
    }

    static SSLContext newClientContext() {
        try {
            KeyStore keyStore = TLSUtils.loadKeyStore(CLIENT_KEY_STORE);
            KeyStore trustStore = TLSUtils.loadKeyStore(CLIENT_TRUST_STORE);
            return TLSUtils.createSSLContext(keyStore, trustStore);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create client SSLContext", e);
        }
    }

    private static KeyStore loadKeyStore(String name) throws IOException {
        try (InputStream stream = TLSUtils.class.getClassLoader().getResourceAsStream(name);){
            if (stream == null) {
                throw new RuntimeException("Could not load keystore");
            }
            try {
                KeyStore loadedKeystore = KeyStore.getInstance("JKS");
                loadedKeystore.load(stream, STORE_PASSWORD);
                KeyStore keyStore = loadedKeystore;
                return keyStore;
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IOException("Unable to load KeyStore " + name, e);
            }
        }
    }

    private static SSLContext createSSLContext(KeyStore keyStore, KeyStore trustStore) throws IOException {
        TrustManager[] trustManagers;
        KeyManager[] keyManagers;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, STORE_PASSWORD);
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new IOException("Unable to initialise KeyManager[]", e);
        }
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new IOException("Unable to initialise TrustManager[]", e);
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IOException("Unable to create and initialise the SSLContext", e);
        }
    }

    private TLSUtils() {
    }
}

