/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.benchmarks;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.benchmarks.BenchmarkUtils;
import io.undertow.benchmarks.TLSUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.util.Headers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;

@State(value=Scope.Benchmark)
public class SimpleBenchmarkState {
    private static final int PORT = 4433;
    @Param(value={"HTTP", "HTTPS"})
    private ListenerType listenerType;
    private Undertow undertow;
    private CloseableHttpClient client;
    private String baseUri;

    @Setup
    public final void before() {
        Undertow.Builder builder = Undertow.builder().setIoThreads(4).setWorkerThreads(64).setServerOption(UndertowOptions.SHUTDOWN_TIMEOUT, 10000).setSocketOption(Options.SSL_CLIENT_AUTH_MODE, SslClientAuthMode.NOT_REQUESTED).setHandler(Handlers.routing().get("/blocking", new BlockingHandler(new HttpHandler(){

            @Override
            public void handleRequest(HttpServerExchange exchange) throws Exception {
                String value = exchange.getQueryParameters().get("size").getFirst();
                int bytes = Integer.parseInt(value);
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/octet-stream").put(Headers.CONTENT_LENGTH, value);
                OutputStream out = exchange.getOutputStream();
                for (int i = 0; i < bytes; ++i) {
                    out.write(1);
                }
            }
        })).post("/blocking", new BlockingHandler(new HttpHandler(){

            @Override
            public void handleRequest(HttpServerExchange exchange) throws Exception {
                InputStream stream = exchange.getInputStream();
                long length = BenchmarkUtils.length(stream);
                String stringValue = Long.toString(length);
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain").put(Headers.CONTENT_LENGTH, stringValue.length());
                exchange.getResponseSender().send(stringValue);
            }
        })));
        switch (this.listenerType) {
            case HTTP: {
                builder.addHttpListener(4433, "0.0.0.0");
                break;
            }
            case HTTPS: {
                builder.addHttpsListener(4433, "0.0.0.0", TLSUtils.newServerContext());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown protocol: " + this.listenerType);
            }
        }
        this.undertow = builder.build();
        this.undertow.start();
        this.client = HttpClients.custom().disableConnectionState().disableAutomaticRetries().setSSLContext(TLSUtils.newClientContext()).setMaxConnPerRoute(100).setMaxConnTotal(100).build();
        this.baseUri = (this.listenerType == ListenerType.HTTP ? "http" : "https") + "://localhost:4433";
    }

    @TearDown
    public final void after() throws IOException {
        if (this.undertow != null) {
            this.undertow.stop();
            this.undertow = null;
        }
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public CloseableHttpClient client() {
        return this.client;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public static enum ListenerType {
        HTTP,
        HTTPS;

    }
}

