/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner.options;

import joptsimple.ValueConversionException;
import joptsimple.ValueConverter;
import joptsimple.internal.Reflection;

public class IntegerValueConverter
implements ValueConverter<Integer> {
    private static final ValueConverter<Integer> TO_INT_CONVERTER = Reflection.findConverter(Integer.TYPE);
    public static final IntegerValueConverter POSITIVE = new IntegerValueConverter(1);
    public static final IntegerValueConverter NON_NEGATIVE = new IntegerValueConverter(0);
    private final int minValue;

    public IntegerValueConverter(int minValue) {
        this.minValue = minValue;
    }

    @Override
    public Integer convert(String value) {
        Integer newValue = TO_INT_CONVERTER.convert(value);
        if (newValue == null) {
            throw new ValueConversionException("value should not be null");
        }
        if (newValue < this.minValue) {
            String message = "The given value " + value + " should be ";
            message = this.minValue == 0 ? message + "non-negative" : (this.minValue == 1 ? message + "positive" : message + "greater or equal than " + this.minValue);
            throw new ValueConversionException(message);
        }
        return newValue;
    }

    @Override
    public Class<Integer> valueType() {
        return TO_INT_CONVERTER.valueType();
    }

    @Override
    public String valuePattern() {
        return "int";
    }
}

