/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class InputStreamDrainer
extends Thread {
    private static final int BUF_SIZE = 1024;
    private final List<OutputStream> outs;
    private final InputStream in;

    public InputStreamDrainer(InputStream in) {
        this(in, null);
    }

    public InputStreamDrainer(InputStream in, OutputStream out) {
        this.in = in;
        this.outs = new ArrayList<OutputStream>();
        this.addOutputStream(out);
    }

    public void addOutputStream(OutputStream out) {
        if (out != null) {
            this.outs.add(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] buf = new byte[1024];
        try {
            int read;
            while ((read = this.in.read(buf)) != -1) {
                for (OutputStream out : this.outs) {
                    out.write(buf, 0, read);
                }
            }
            for (OutputStream out : this.outs) {
                out.flush();
            }
        }
        catch (IOException ioe) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ioe.getMessage(), ioe);
        }
        finally {
            try {
                this.in.close();
            }
            catch (IOException ioe) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ioe.getMessage(), ioe);
            }
        }
    }
}

