/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.handlers;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpHandlers;
import io.undertow.util.Headers;
import java.net.URI;
import java.net.URISyntaxException;

public abstract class AbstractConfidentialityHandler
implements HttpHandler {
    private final HttpHandler next;

    protected AbstractConfidentialityHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) {
        if (this.isConfidential(exchange) || !this.confidentialityRequired(exchange)) {
            HttpHandlers.executeHandler(this.next, exchange);
        } else {
            try {
                URI redirectUri = this.getRedirectURI(exchange);
                exchange.setResponseCode(302);
                exchange.getResponseHeaders().put(Headers.LOCATION, redirectUri.toString());
            }
            catch (URISyntaxException e) {
                UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest(e);
                exchange.setResponseCode(500);
            }
            exchange.endExchange();
        }
    }

    protected boolean isConfidential(HttpServerExchange exchange) {
        return exchange.getRequestScheme().equals("https");
    }

    protected boolean confidentialityRequired(HttpServerExchange exchange) {
        return true;
    }

    protected abstract URI getRedirectURI(HttpServerExchange var1) throws URISyntaxException;
}

