/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.predicate.Predicate;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpHandlers;

public class PredicateHandler
implements HttpHandler {
    private volatile Predicate<HttpServerExchange> predicate;
    private volatile HttpHandler trueHandler;
    private volatile HttpHandler falseHandler;

    public PredicateHandler(Predicate<HttpServerExchange> predicate, HttpHandler trueHandler, HttpHandler falseHandler) {
        this.predicate = predicate;
        this.trueHandler = trueHandler;
        this.falseHandler = falseHandler;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) {
        HttpHandler next = this.predicate.resolve(exchange) ? this.trueHandler : this.falseHandler;
        HttpHandlers.executeHandler(next, exchange);
    }

    public Predicate<HttpServerExchange> getPredicate() {
        return this.predicate;
    }

    public PredicateHandler setPredicate(Predicate<HttpServerExchange> predicate) {
        this.predicate = predicate;
        return this;
    }

    public HttpHandler getTrueHandler() {
        return this.trueHandler;
    }

    public PredicateHandler setTrueHandler(HttpHandler trueHandler) {
        this.trueHandler = trueHandler;
        return this;
    }

    public HttpHandler getFalseHandler() {
        return this.falseHandler;
    }

    public PredicateHandler setFalseHandler(HttpHandler falseHandler) {
        this.falseHandler = falseHandler;
        return this;
    }
}

