/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.blocking;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.blocking.BlockingHttpHandler;
import io.undertow.util.WorkerDispatcher;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class BlockingHandler
implements HttpHandler {
    private volatile BlockingHttpHandler handler;
    private static final AtomicReferenceFieldUpdater<BlockingHandler, BlockingHttpHandler> handlerUpdater = AtomicReferenceFieldUpdater.newUpdater(BlockingHandler.class, BlockingHttpHandler.class, "handler");

    public BlockingHandler(BlockingHttpHandler handler) {
        this.handler = handler;
    }

    public BlockingHandler() {
        this(null);
    }

    @Override
    public void handleRequest(final HttpServerExchange exchange) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    exchange.startBlocking();
                    BlockingHttpHandler handler = BlockingHandler.this.handler;
                    if (handler != null) {
                        handler.handleBlockingRequest(exchange);
                    }
                }
                catch (Throwable t) {
                    if (!exchange.isResponseStarted()) {
                        exchange.setResponseCode(500);
                    }
                    UndertowLogger.REQUEST_LOGGER.errorf(t, "Blocking request failed %s", exchange);
                }
                finally {
                    exchange.endExchange();
                }
            }
        };
        WorkerDispatcher.dispatch(exchange, runnable);
    }

    public BlockingHttpHandler getHandler() {
        return this.handler;
    }

    public BlockingHttpHandler setRootHandler(BlockingHttpHandler rootHandler) {
        return handlerUpdater.getAndSet(this, rootHandler);
    }
}

