/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.cache;

import io.undertow.server.handlers.cache.ConcurrentDirectDeque;
import io.undertow.server.handlers.cache.LimitedBufferSlicePool;
import io.undertow.util.SecureHashMap;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.xnio.BufferAllocator;

public class DirectBufferCache<K> {
    private static final int SAMPLE_INTERVAL = 5;
    private final LimitedBufferSlicePool pool;
    private final SecureHashMap<K, CacheEntry<K>> cache;
    private final ConcurrentDirectDeque<CacheEntry<K>> accessQueue;
    private final int sliceSize;

    public DirectBufferCache(int sliceSize, int max) {
        this(sliceSize, max, (BufferAllocator<ByteBuffer>)BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR);
    }

    public DirectBufferCache(int sliceSize, int max, BufferAllocator<ByteBuffer> bufferAllocator) {
        this.sliceSize = sliceSize;
        this.pool = new LimitedBufferSlicePool(bufferAllocator, sliceSize, max, 1);
        this.cache = new SecureHashMap(16);
        this.accessQueue = ConcurrentDirectDeque.newInstance();
    }

    public CacheEntry add(K key, int size) {
        CacheEntry<K> value = this.cache.get(key);
        if (value == null) {
            value = new CacheEntry(key, size, this);
            CacheEntry<K> result = this.cache.putIfAbsent(key, value);
            if (result != null) {
                value = result;
            } else {
                this.bumpAccess(value);
            }
        }
        return value;
    }

    public CacheEntry<K> get(K key) {
        CacheEntry<K> cacheEntry = this.cache.get(key);
        if (cacheEntry == null) {
            return null;
        }
        if (cacheEntry.hit() % 5 == 0) {
            this.bumpAccess(cacheEntry);
            if (!cacheEntry.allocate()) {
                int reclaimSize = cacheEntry.size();
                for (CacheEntry cacheEntry2 : this.accessQueue) {
                    if (cacheEntry2 == cacheEntry) continue;
                    if (cacheEntry2.buffers().length > 0) {
                        reclaimSize -= cacheEntry2.size();
                    }
                    this.remove(cacheEntry2.key());
                    if (reclaimSize > 0) continue;
                    break;
                }
                cacheEntry.allocate();
            }
        }
        return cacheEntry;
    }

    private void bumpAccess(CacheEntry<K> cacheEntry) {
        Object prevToken = cacheEntry.claimToken();
        if (prevToken != Boolean.FALSE) {
            if (prevToken != null) {
                this.accessQueue.removeToken(prevToken);
            }
            Object token = null;
            try {
                token = this.accessQueue.offerLastAndReturnToken(cacheEntry);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (!cacheEntry.setToken(token) && token != null) {
                this.accessQueue.removeToken(token);
            }
        }
    }

    public void remove(K key) {
        CacheEntry<K> remove = this.cache.remove(key);
        if (remove != null) {
            Object old = remove.clearToken();
            if (old != null) {
                this.accessQueue.removeToken(old);
            }
            remove.dereference();
        }
    }

    public static final class CacheEntry<K> {
        private static final LimitedBufferSlicePool.PooledByteBuffer[] EMPTY_BUFFERS = new LimitedBufferSlicePool.PooledByteBuffer[0];
        private static final LimitedBufferSlicePool.PooledByteBuffer[] INIT_BUFFERS = new LimitedBufferSlicePool.PooledByteBuffer[0];
        private static final Object CLAIM_TOKEN = new Object();
        private static final AtomicIntegerFieldUpdater<CacheEntry> hitsUpdater = AtomicIntegerFieldUpdater.newUpdater(CacheEntry.class, "hits");
        private static final AtomicIntegerFieldUpdater<CacheEntry> refsUpdater = AtomicIntegerFieldUpdater.newUpdater(CacheEntry.class, "refs");
        private static final AtomicIntegerFieldUpdater<CacheEntry> enabledUpdator = AtomicIntegerFieldUpdater.newUpdater(CacheEntry.class, "enabled");
        private static final AtomicReferenceFieldUpdater<CacheEntry, LimitedBufferSlicePool.PooledByteBuffer[]> bufsUpdater = AtomicReferenceFieldUpdater.newUpdater(CacheEntry.class, LimitedBufferSlicePool.PooledByteBuffer[].class, "buffers");
        private static final AtomicReferenceFieldUpdater<CacheEntry, Object> tokenUpdator = AtomicReferenceFieldUpdater.newUpdater(CacheEntry.class, Object.class, "accessToken");
        private final K key;
        private final int size;
        private final DirectBufferCache<K> cache;
        private volatile LimitedBufferSlicePool.PooledByteBuffer[] buffers = INIT_BUFFERS;
        private volatile int refs = 1;
        private volatile int hits = 1;
        private volatile Object accessToken;
        private volatile int enabled;

        private CacheEntry(K key, int size, DirectBufferCache cache) {
            this.key = key;
            this.size = size;
            this.cache = cache;
        }

        public int size() {
            return this.size;
        }

        public LimitedBufferSlicePool.PooledByteBuffer[] buffers() {
            return this.buffers;
        }

        public int hit() {
            int i;
            do {
                i = this.hits;
            } while (!hitsUpdater.weakCompareAndSet(this, i++, i));
            return i;
        }

        public K key() {
            return this.key;
        }

        public boolean enabled() {
            return this.enabled == 2;
        }

        public void enable() {
            this.enabled = 2;
        }

        public void disable() {
            this.enabled = 0;
        }

        public boolean claimEnable() {
            return enabledUpdator.compareAndSet(this, 0, 1);
        }

        public boolean reference() {
            int refs;
            do {
                if ((refs = this.refs) >= 1) continue;
                return false;
            } while (!refsUpdater.compareAndSet(this, refs++, refs));
            return true;
        }

        public boolean dereference() {
            int refs;
            do {
                if ((refs = this.refs) >= 1) continue;
                return false;
            } while (!refsUpdater.compareAndSet(this, refs--, refs));
            if (refs == 0) {
                this.destroy();
            }
            return true;
        }

        public boolean allocate() {
            if (this.buffers.length > 0) {
                return true;
            }
            if (!bufsUpdater.compareAndSet(this, INIT_BUFFERS, EMPTY_BUFFERS)) {
                return true;
            }
            int reserveSize = this.size;
            int n = 1;
            DirectBufferCache<K> bufferCache = this.cache;
            while ((reserveSize -= ((DirectBufferCache)bufferCache).sliceSize) > 0) {
                ++n;
            }
            LimitedBufferSlicePool slicePool = ((DirectBufferCache)bufferCache).pool;
            if (!slicePool.canAllocate(n)) {
                this.buffers = INIT_BUFFERS;
                return false;
            }
            LimitedBufferSlicePool.PooledByteBuffer[] buffers = new LimitedBufferSlicePool.PooledByteBuffer[n];
            for (int i = 0; i < n; ++i) {
                LimitedBufferSlicePool.PooledByteBuffer allocate = slicePool.allocate();
                if (allocate == null) {
                    while (--i >= 0) {
                        buffers[i].free();
                    }
                    this.buffers = INIT_BUFFERS;
                    return false;
                }
                buffers[i] = allocate;
            }
            this.buffers = buffers;
            return true;
        }

        private void destroy() {
            for (LimitedBufferSlicePool.PooledByteBuffer buffer : this.buffers = EMPTY_BUFFERS) {
                buffer.free();
            }
        }

        Object claimToken() {
            Object current;
            do {
                if ((current = this.accessToken) != CLAIM_TOKEN) continue;
                return Boolean.FALSE;
            } while (!tokenUpdator.compareAndSet(this, current, CLAIM_TOKEN));
            return current;
        }

        boolean setToken(Object token) {
            return tokenUpdator.compareAndSet(this, CLAIM_TOKEN, token);
        }

        Object clearToken() {
            Object old = tokenUpdator.getAndSet(this, null);
            return old == CLAIM_TOKEN ? null : old;
        }
    }
}

