/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jboss.logging.Logger;
import org.xnio.ChannelListener;
import org.xnio.FileAccess;
import org.xnio.IoUtils;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.SuspendableWriteChannel;

public class FileResource
implements Resource {
    private static final Logger log = Logger.getLogger((String)"io.undertow.server.resources.file");
    private final File file;

    public FileResource(File file) {
        this.file = file;
    }

    @Override
    public Date getLastModified() {
        return new Date(this.file.lastModified());
    }

    @Override
    public ETag getETag() {
        return null;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public List<Resource> list() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String f : this.file.list()) {
            File child = new File(this.file, f);
            resources.add(new FileResource(child));
        }
        return resources;
    }

    @Override
    public String getContentType(MimeMappings mimeMappings) {
        String fileName = this.file.getName();
        int index = fileName.lastIndexOf(46);
        if (index != -1 && index != fileName.length() - 1) {
            return mimeMappings.getMimeType(fileName.substring(index + 1));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serve(HttpServerExchange exchange) {
        FileChannel fileChannel;
        try {
            try {
                fileChannel = exchange.getConnection().getWorker().getXnio().openFile(this.file, FileAccess.READ_ONLY);
            }
            catch (FileNotFoundException e) {
                exchange.setResponseCode(404);
                exchange.endExchange();
                return;
            }
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_LOGGER.exceptionReadingFile(this.file, e);
            exchange.setResponseCode(500);
            exchange.endExchange();
            return;
        }
        StreamSinkChannel response = exchange.getResponseChannel();
        response.getCloseSetter().set((ChannelListener)new ChannelListener<Channel>(){

            public void handleEvent(Channel channel) {
                IoUtils.safeClose((Closeable)fileChannel);
            }
        });
        try {
            log.tracef("Serving file %s (blocking)", (Object)fileChannel);
            Channels.transferBlocking((StreamSinkChannel)response, (FileChannel)fileChannel, (long)0L, (long)this.file.length());
            log.tracef("Finished serving %s, shutting down (blocking)", (Object)fileChannel);
            response.shutdownWrites();
            log.tracef("Finished serving %s, flushing (blocking)", (Object)fileChannel);
            Channels.flushBlocking((SuspendableWriteChannel)response);
            log.tracef("Finished serving %s (complete)", (Object)fileChannel);
            exchange.endExchange();
        }
        catch (IOException ignored) {
            log.tracef("Failed to serve %s: %s", (Object)fileChannel, (Object)ignored);
            exchange.endExchange();
            IoUtils.safeClose((Closeable)response);
        }
        finally {
            IoUtils.safeClose((Closeable)fileChannel);
        }
    }

    @Override
    public Long getContentLength() {
        return this.file.length();
    }
}

