/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.spi;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.ConcreteIoFuture;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import io.undertow.websockets.spi.UpgradeCallback;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xnio.ChannelListener;
import org.xnio.FinishedIoFuture;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.channels.StreamSourceChannel;

public class AsyncWebSocketHttpServerExchange
implements WebSocketHttpExchange {
    private final HttpServerExchange exchange;
    private Sender sender;

    public AsyncWebSocketHttpServerExchange(HttpServerExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public String getRequestHeader(String headerName) {
        return this.exchange.getRequestHeaders().getFirst(HttpString.tryFromString(headerName));
    }

    @Override
    public Map<String, List<String>> getRequestHeaders() {
        HashMap<String, ArrayList<String>> headers = new HashMap<String, ArrayList<String>>();
        for (HttpString header : this.exchange.getRequestHeaders().getHeaderNames()) {
            headers.put(header.toString(), new ArrayList<String>(this.exchange.getRequestHeaders().get(header)));
        }
        return Collections.unmodifiableMap(headers);
    }

    @Override
    public String getResponseHeader(String headerName) {
        return this.exchange.getResponseHeaders().getFirst(HttpString.tryFromString(headerName));
    }

    @Override
    public Map<String, List<String>> getResponseHeaders() {
        HashMap<String, ArrayList<String>> headers = new HashMap<String, ArrayList<String>>();
        for (HttpString header : this.exchange.getResponseHeaders().getHeaderNames()) {
            headers.put(header.toString(), new ArrayList<String>(this.exchange.getResponseHeaders().get(header)));
        }
        return Collections.unmodifiableMap(headers);
    }

    @Override
    public void setResponseHeaders(Map<String, List<String>> headers) {
        HeaderMap map = this.exchange.getRequestHeaders();
        map.clear();
        for (Map.Entry<String, List<String>> header : headers.entrySet()) {
            map.addAll(HttpString.tryFromString(header.getKey()), (Collection<String>)header.getValue());
        }
    }

    @Override
    public void setResponseHeader(String headerName, String headerValue) {
        this.exchange.getResponseHeaders().put(HttpString.tryFromString(headerName), headerValue);
    }

    @Override
    public void setResponesCode(int code) {
        this.exchange.setResponseCode(code);
    }

    @Override
    public void upgradeChannel(final UpgradeCallback upgradeCallback) {
        this.exchange.upgradeChannel(new ExchangeCompletionListener(){

            @Override
            public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                upgradeCallback.handleUpgrade(exchange.getConnection().getChannel(), exchange.getConnection().getBufferPool());
            }
        });
    }

    @Override
    public IoFuture<Void> sendData(ByteBuffer data) {
        if (this.sender == null) {
            this.sender = this.exchange.getResponseSender();
        }
        final ConcreteIoFuture future = new ConcreteIoFuture();
        this.sender.send(data, new IoCallback(){

            @Override
            public void onComplete(HttpServerExchange exchange, Sender sender) {
                future.setResult(null);
            }

            @Override
            public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                future.setException(exception);
            }
        });
        return future;
    }

    @Override
    public IoFuture<byte[]> readRequestData() {
        final ByteArrayOutputStream data = new ByteArrayOutputStream();
        Pooled pooled = this.exchange.getConnection().getBufferPool().allocate();
        final ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        StreamSourceChannel channel = this.exchange.getRequestChannel();
        try {
            while (true) {
                int res;
                if ((res = channel.read(buffer)) == -1) {
                    return new FinishedIoFuture((Object)data.toByteArray());
                }
                if (res == 0) {
                    final ConcreteIoFuture future = new ConcreteIoFuture();
                    channel.getReadSetter().set((ChannelListener)new ChannelListener<StreamSourceChannel>(){

                        public void handleEvent(StreamSourceChannel channel) {
                            try {
                                int res = channel.read(buffer);
                                if (res == -1) {
                                    future.setResult(data.toByteArray());
                                    channel.suspendReads();
                                    return;
                                }
                                if (res == 0) {
                                    return;
                                }
                                buffer.flip();
                                while (buffer.hasRemaining()) {
                                    data.write(buffer.get());
                                }
                                buffer.clear();
                            }
                            catch (IOException e) {
                                future.setException(e);
                            }
                        }
                    });
                    channel.resumeReads();
                    return future;
                }
                buffer.flip();
                while (buffer.hasRemaining()) {
                    data.write(buffer.get());
                }
                buffer.clear();
            }
        }
        catch (IOException e) {
            ConcreteIoFuture future = new ConcreteIoFuture();
            future.setException(e);
            return future;
        }
    }

    @Override
    public void endExchange() {
        this.exchange.endExchange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.exchange.endExchange();
        }
        finally {
            IoUtils.safeClose((Closeable)((Object)this.exchange.getConnection()));
        }
    }

    @Override
    public String getRequestScheme() {
        return this.exchange.getRequestScheme();
    }

    @Override
    public String getRequestURI() {
        return this.exchange.getRequestURI();
    }

    @Override
    public Pool<ByteBuffer> getBufferPool() {
        return this.exchange.getConnection().getBufferPool();
    }

    @Override
    public String getQueryString() {
        return this.getQueryString();
    }
}

