/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.UndertowMessages;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.api.SecurityNotification;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.server.HttpServerExchange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SecurityContextImpl
implements SecurityContext {
    private static final RuntimePermission PERMISSION = new RuntimePermission("MODIFY_UNDERTOW_SECURITY_CONTEXT");
    private final AuthenticationMode authenticationMode;
    private boolean authenticationRequired;
    private String programaticMechName = "Programatic";
    private AuthenticationState authenticationState = AuthenticationState.NOT_ATTEMPTED;
    private final HttpServerExchange exchange;
    private final List<AuthenticationMechanism> authMechanisms = new ArrayList<AuthenticationMechanism>();
    private final IdentityManager identityManager;
    private final List<NotificationReceiver> notificationReceivers = new ArrayList<NotificationReceiver>();
    private String mechanismName;
    private Account account;

    public SecurityContextImpl(HttpServerExchange exchange, IdentityManager identityManager) {
        this(exchange, AuthenticationMode.PRO_ACTIVE, identityManager);
    }

    public SecurityContextImpl(HttpServerExchange exchange, AuthenticationMode authenticationMode, IdentityManager identityManager) {
        this.authenticationMode = authenticationMode;
        this.identityManager = identityManager;
        this.exchange = exchange;
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(PERMISSION);
        }
    }

    @Override
    public boolean authenticate() {
        return !this.authTransition();
    }

    private boolean authTransition() {
        if (this.authTransitionRequired()) {
            switch (this.authenticationState) {
                case NOT_ATTEMPTED: {
                    this.authenticationState = this.attemptAuthentication();
                    break;
                }
                case ATTEMPTED: {
                    this.authenticationState = this.sendChallenges();
                    break;
                }
                default: {
                    throw new IllegalStateException("It should not be possible to reach this.");
                }
            }
            return this.authTransition();
        }
        switch (this.authenticationState) {
            case NOT_ATTEMPTED: 
            case ATTEMPTED: 
            case AUTHENITCATED: {
                return false;
            }
        }
        return true;
    }

    private AuthenticationState attemptAuthentication() {
        return new AuthAttempter(this.authMechanisms.iterator(), this.exchange).transition();
    }

    private AuthenticationState sendChallenges() {
        return new ChallengeSender(this.authMechanisms.iterator(), this.exchange).transition();
    }

    private boolean authTransitionRequired() {
        switch (this.authenticationState) {
            case NOT_ATTEMPTED: {
                return this.authenticationRequired || this.authenticationMode == AuthenticationMode.PRO_ACTIVE;
            }
            case ATTEMPTED: {
                return this.authenticationRequired;
            }
        }
        return false;
    }

    @Override
    public void setAuthenticationRequired() {
        this.authenticationRequired = true;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticationState == AuthenticationState.AUTHENITCATED;
    }

    public void setProgramaticMechName(String programaticMechName) {
        this.programaticMechName = programaticMechName;
    }

    @Override
    public String getMechanismName() {
        return this.mechanismName;
    }

    @Override
    public void addAuthenticationMechanism(AuthenticationMechanism handler) {
        this.authMechanisms.add(handler);
    }

    @Override
    public List<AuthenticationMechanism> getAuthenticationMechanisms() {
        return Collections.unmodifiableList(this.authMechanisms);
    }

    @Override
    public Account getAuthenticatedAccount() {
        return this.account;
    }

    @Override
    public IdentityManager getIdentityManager() {
        return this.identityManager;
    }

    @Override
    public boolean login(String username, String password) {
        Account account = this.identityManager.verify(username, new PasswordCredential(password.toCharArray()));
        if (account == null) {
            return false;
        }
        this.authenticationComplete(account, this.programaticMechName, true);
        this.authenticationState = AuthenticationState.AUTHENITCATED;
        return true;
    }

    @Override
    public void logout() {
        this.sendNoticiation(new SecurityNotification(this.exchange, SecurityNotification.EventType.LOGGED_OUT, this.account, this.mechanismName, true, UndertowMessages.MESSAGES.userLoggedOut(this.account.getPrincipal().getName())));
        this.account = null;
        this.mechanismName = null;
        this.authenticationState = AuthenticationState.NOT_ATTEMPTED;
    }

    @Override
    public void authenticationComplete(Account account, String mechanism) {
        this.authenticationComplete(account, mechanism, false);
    }

    protected void authenticationComplete(Account account, String mechanism, boolean programatic) {
        this.account = account;
        this.mechanismName = mechanism;
        this.sendNoticiation(new SecurityNotification(this.exchange, SecurityNotification.EventType.AUTHENTICATED, account, mechanism, programatic, UndertowMessages.MESSAGES.userAuthenticated(account.getPrincipal().getName())));
    }

    @Override
    public void authenticationFailed(String message, String mechanism) {
        this.sendNoticiation(new SecurityNotification(this.exchange, SecurityNotification.EventType.FAILED_AUTHENTICATION, null, mechanism, false, message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNoticiation(SecurityNotification notification) {
        List<NotificationReceiver> list = this.notificationReceivers;
        synchronized (list) {
            for (NotificationReceiver current : this.notificationReceivers) {
                current.handleNotification(notification);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerNotificationReceiver(NotificationReceiver receiver) {
        List<NotificationReceiver> list = this.notificationReceivers;
        synchronized (list) {
            this.notificationReceivers.add(receiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationReceiver(NotificationReceiver receiver) {
        List<NotificationReceiver> list = this.notificationReceivers;
        synchronized (list) {
            this.notificationReceivers.remove(receiver);
        }
    }

    static enum AuthenticationState {
        NOT_ATTEMPTED,
        ATTEMPTED,
        AUTHENITCATED,
        CHALLENGE_SENT;

    }

    private class ChallengeSender {
        private final Iterator<AuthenticationMechanism> mechanismIterator;
        private final HttpServerExchange exchange;
        private boolean atLeastOneChallenge = false;
        private Integer chosenStatusCode = null;

        private ChallengeSender(Iterator<AuthenticationMechanism> mechanismIterator, HttpServerExchange exchange) {
            this.mechanismIterator = mechanismIterator;
            this.exchange = exchange;
        }

        private AuthenticationState transition() {
            if (this.mechanismIterator.hasNext()) {
                AuthenticationMechanism mechanism = this.mechanismIterator.next();
                AuthenticationMechanism.ChallengeResult result = mechanism.sendChallenge(this.exchange, SecurityContextImpl.this);
                if (result.isChallengeSent()) {
                    this.atLeastOneChallenge = true;
                    Integer desiredCode = result.getDesiredResponseCode();
                    if (this.chosenStatusCode == null) {
                        this.chosenStatusCode = desiredCode;
                    } else if (desiredCode != null && this.chosenStatusCode.equals(200)) {
                        this.chosenStatusCode = desiredCode;
                    }
                }
                return this.transition();
            }
            if (this.atLeastOneChallenge) {
                if (this.chosenStatusCode != null) {
                    this.exchange.setResponseCode(this.chosenStatusCode);
                }
            } else {
                this.exchange.setResponseCode(403);
            }
            return AuthenticationState.CHALLENGE_SENT;
        }
    }

    private class AuthAttempter {
        private final Iterator<AuthenticationMechanism> mechanismIterator;
        private final HttpServerExchange exchange;

        private AuthAttempter(Iterator<AuthenticationMechanism> mechanismIterator, HttpServerExchange exchange) {
            this.mechanismIterator = mechanismIterator;
            this.exchange = exchange;
        }

        private AuthenticationState transition() {
            if (this.mechanismIterator.hasNext()) {
                AuthenticationMechanism mechanism = this.mechanismIterator.next();
                AuthenticationMechanism.AuthenticationMechanismOutcome outcome = mechanism.authenticate(this.exchange, SecurityContextImpl.this);
                switch (outcome) {
                    case AUTHENTICATED: {
                        return AuthenticationState.AUTHENITCATED;
                    }
                    case NOT_AUTHENTICATED: {
                        SecurityContextImpl.this.setAuthenticationRequired();
                        return AuthenticationState.ATTEMPTED;
                    }
                    case NOT_ATTEMPTED: {
                        return this.transition();
                    }
                }
                throw new IllegalStateException();
            }
            return AuthenticationState.ATTEMPTED;
        }
    }
}

