/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowLogger;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.DateUtils;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jboss.logging.Logger;
import org.xnio.FileAccess;
import org.xnio.IoUtils;
import org.xnio.Pooled;

public class FileResource
implements Resource {
    private static final Logger log = Logger.getLogger((String)"io.undertow.server.resources.file");
    private final Path file;

    public FileResource(Path file) {
        this.file = file;
    }

    @Override
    public Date getLastModified() {
        try {
            return new Date(Files.getLastModifiedTime(this.file, new LinkOption[0]).toMillis());
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getLastModifiedString() {
        Date lastModified = this.getLastModified();
        if (lastModified == null) {
            return null;
        }
        return DateUtils.toDateString(lastModified);
    }

    @Override
    public ETag getETag() {
        return null;
    }

    @Override
    public String getName() {
        return this.file.getFileName().toString();
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.file, new LinkOption[0]);
    }

    @Override
    public List<Resource> list() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.file);){
            for (Path child : stream) {
                resources.add(new FileResource(child));
            }
        }
        catch (IOException | DirectoryIteratorException x) {
            UndertowLogger.ROOT_LOGGER.warn("could not list directory", x);
        }
        return resources;
    }

    @Override
    public String getContentType(MimeMappings mimeMappings) {
        String fileName = this.file.getFileName().toString();
        int index = fileName.lastIndexOf(46);
        if (index != -1 && index != fileName.length() - 1) {
            return mimeMappings.getMimeType(fileName.substring(index + 1));
        }
        return null;
    }

    @Override
    public void serve(final HttpServerExchange exchange) {
        class ServerTask
        implements Runnable,
        IoCallback {
            private FileChannel fileChannel;
            private Pooled<ByteBuffer> pooled;
            private Sender sender;

            ServerTask() {
            }

            @Override
            public void run() {
                if (this.fileChannel == null) {
                    try {
                        this.fileChannel = exchange.getConnection().getWorker().getXnio().openFile(FileResource.this.file.toFile(), FileAccess.READ_ONLY);
                    }
                    catch (FileNotFoundException e) {
                        exchange.setResponseCode(404);
                        return;
                    }
                    catch (IOException e) {
                        exchange.setResponseCode(500);
                        return;
                    }
                    this.pooled = exchange.getConnection().getBufferPool().allocate();
                    this.sender = exchange.getResponseSender();
                }
                ByteBuffer buffer = (ByteBuffer)this.pooled.getResource();
                try {
                    buffer.clear();
                    int res = this.fileChannel.read(buffer);
                    if (res == -1) {
                        this.sender.close();
                        return;
                    }
                    buffer.flip();
                    this.sender.send(buffer, (IoCallback)this);
                }
                catch (IOException e) {
                    this.onException(exchange, this.sender, e);
                }
            }

            @Override
            public void onComplete(HttpServerExchange exchange2, Sender sender) {
                if (exchange2.isInIoThread()) {
                    exchange2.dispatch(this);
                } else {
                    this.run();
                }
            }

            @Override
            public void onException(HttpServerExchange exchange2, Sender sender, IOException exception) {
                if (this.pooled != null) {
                    this.pooled.free();
                }
                IoUtils.safeClose((Closeable)this.fileChannel);
                if (!exchange2.isResponseStarted()) {
                    exchange2.setResponseCode(500);
                }
                exchange2.endExchange();
            }
        }
        ServerTask serveTask = new ServerTask();
        if (exchange.isInIoThread()) {
            exchange.dispatch(serveTask);
        } else {
            serveTask.run();
        }
    }

    @Override
    public Long getContentLength() {
        try {
            return Files.size(this.file);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public Resource getIndexResource(List<String> possible) {
        for (String possibility : possible) {
            Path index = this.file.resolve(possibility);
            if (!Files.exists(index, new LinkOption[0])) continue;
            return new FileResource(index);
        }
        return null;
    }

    @Override
    public String getCacheKey() {
        return this.file.toString();
    }

    @Override
    public Path getFile() {
        return this.file;
    }

    @Override
    public URL getUrl() {
        try {
            return this.file.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

