/*
 * Decompiled with CFR 0.152.
 */
package io.undertow;

import io.undertow.predicate.PredicateBuilder;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="UT")
public interface UndertowMessages {
    public static final UndertowMessages MESSAGES = (UndertowMessages)Messages.getBundle(UndertowMessages.class);

    @Message(id=1, value="Maximum concurrent requests must be larger than zero.")
    public IllegalArgumentException maximumConcurrentRequestsMustBeLargerThanZero();

    @Message(id=2, value="The response has already been started")
    public IllegalStateException responseAlreadyStarted();

    @Message(id=4, value="getResponseChannel() has already been called")
    public IllegalStateException responseChannelAlreadyProvided();

    @Message(id=5, value="getRequestChannel() has already been called")
    public IllegalStateException requestChannelAlreadyProvided();

    @Message(id=8, value="Handler cannot be null")
    public IllegalArgumentException handlerCannotBeNull();

    @Message(id=9, value="Path must be specified")
    public IllegalArgumentException pathMustBeSpecified();

    @Message(id=10, value="Session not found %s")
    public IllegalStateException sessionNotFound(String var1);

    @Message(id=11, value="Session manager must not be null")
    public IllegalStateException sessionManagerMustNotBeNull();

    @Message(id=12, value="Session manager was not attached to the request. Make sure that the SessionAttachmentHander is installed in the handler chain")
    public IllegalStateException sessionManagerNotFound();

    @Message(id=13, value="Argument %s cannot be null")
    public IllegalArgumentException argumentCannotBeNull(String var1);

    @Message(id=14, value="close() called with data still to be flushed. Please call shutdownWrites() and then call flush() until it returns true before calling close()")
    public IOException closeCalledWithDataStillToBeFlushed();

    @Message(id=16, value="Could not add cookie as cookie handler was not present in the handler chain")
    public IllegalStateException cookieHandlerNotPresent();

    @Message(id=17, value="Form value is a file, use getFile() instead")
    public IllegalStateException formValueIsAFile();

    @Message(id=18, value="Form value is a String, use getValue() instead")
    public IllegalStateException formValueIsAString();

    @Message(id=19, value="Connection from %s terminated as request entity was larger than %s")
    public IOException requestEntityWasTooLarge(SocketAddress var1, long var2);

    @Message(id=20, value="Connection terminated as request was larger than %s")
    public IOException requestEntityWasTooLarge(long var1);

    @Message(id=21, value="Session already invalidated")
    public IllegalStateException sessionAlreadyInvalidated();

    @Message(id=22, value="The specified hash algorithm '%s' can not be found.")
    public IllegalArgumentException hashAlgorithmNotFound(String var1);

    @Message(id=23, value="An invalid Base64 token has been recieved.")
    public IllegalArgumentException invalidBase64Token(@Cause IOException var1);

    @Message(id=24, value="An invalidly formatted nonce has been received.")
    public IllegalArgumentException invalidNonceReceived();

    @Message(id=25, value="Unexpected token '%s' within header.")
    public IllegalArgumentException unexpectedTokenInHeader(String var1);

    @Message(id=26, value="Invalid header received.")
    public IllegalArgumentException invalidHeader();

    @Message(id=27, value="Could not find session cookie config in the request")
    public IllegalStateException couldNotFindSessionCookieConfig();

    @Message(id=28, value="Session %s already exists")
    public IllegalStateException sessionAlreadyExists(String var1);

    @Message(id=29, value="Channel was closed mid chunk, if you have attempted to write chunked data you cannot shutdown the channel until after it has all been written.")
    public IOException chunkedChannelClosedMidChunk();

    @Message(id=30, value="User %s successfuly authenticated.")
    public String userAuthenticated(String var1);

    @Message(id=31, value="User %s has logged out.")
    public String userLoggedOut(String var1);

    @Message(id=33, value="Authentication type %s cannot be combined with %s")
    public IllegalStateException authTypeCannotBeCombined(String var1, String var2);

    @Message(id=34, value="Stream is closed")
    public IOException streamIsClosed();

    @Message(id=35, value="Cannot get stream as startBlocking has not been invoked")
    public IllegalStateException startBlockingHasNotBeenCalled();

    @Message(id=36, value="Connection terminated parsing multipart data")
    public IOException connectionTerminatedReadingMultiPartData();

    @Message(id=37, value="Failed to parse path in HTTP request")
    public RuntimeException failedToParsePath();

    @Message(id=38, value="Authentication failed, requested user name '%s'")
    public String authenticationFailed(String var1);

    @Message(id=39, value="To many query parameters, cannot have more than %s query parameters")
    public RuntimeException tooManyQueryParameters(int var1);

    @Message(id=40, value="To many headers, cannot have more than %s header")
    public RuntimeException tooManyHeaders(int var1);

    @Message(id=41, value="Channel is closed")
    public ClosedChannelException channelIsClosed();

    @Message(id=42, value="Could not decode trailers in HTTP request")
    public IOException couldNotDecodeTrailers();

    @Message(id=43, value="Data is already being sent. You must wait for the completion callback to be be invoked before calling send() again")
    public IllegalStateException dataAlreadyQueued();

    @Message(id=44, value="More than one predicate with name %s. Builder class %s and %s")
    public IllegalStateException moreThanOnePredicateWithName(String var1, Class<? extends PredicateBuilder> var2, Class<? extends PredicateBuilder> var3);

    @Message(id=45, value="Error parsing predicate string %s:%n%s")
    public IllegalArgumentException errorParsingPredicateString(String var1, String var2);

    @Message(id=46, value="The number of cookies sent exceeded the maximum of %s")
    public IllegalStateException tooManyCookies(int var1);

    @Message(id=47, value="The number of parameters exceeded the maximum of %s")
    public IllegalStateException tooManyParameters(int var1);

    @Message(id=48, value="No request is currently active")
    public IllegalStateException noRequestActive();

    @Message(id=50, value="AuthenticationMechanism Outcome is null")
    public IllegalStateException authMechanismOutcomeNull();
}

