/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.test.handlers;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.test.utils.DefaultServer;
import io.undertow.test.utils.HttpClientUtils;
import io.undertow.util.TestHttpClient;
import java.io.IOException;
import java.util.Deque;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class SenderTestCase {
    public static final int SENDS = 10000;

    @BeforeClass
    public static void setup() {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                boolean blocking = ((Deque)exchange.getQueryParameters().get("blocking")).equals("true");
                if (blocking) {
                    exchange.startBlocking();
                }
                final Sender sender = exchange.getResponseSender();
                class SendClass
                implements Runnable,
                IoCallback {
                    int sent = 0;

                    SendClass() {
                    }

                    @Override
                    public void run() {
                        ++this.sent;
                        sender.send("a", (IoCallback)this);
                    }

                    public void onComplete(HttpServerExchange exchange, Sender sender2) {
                        if (this.sent++ == 10000) {
                            sender2.close();
                            return;
                        }
                        sender2.send("a", (IoCallback)this);
                    }

                    public void onException(HttpServerExchange exchange, Sender sender2, IOException exception) {
                        exception.printStackTrace();
                        exchange.endExchange();
                    }
                }
                new SendClass().run();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncSender() throws IOException {
        StringBuilder sb = new StringBuilder(10000);
        for (int i = 0; i < 10000; ++i) {
            sb.append("a");
        }
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/?blocking=false");
        TestHttpClient client = new TestHttpClient();
        try {
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)sb.toString(), (Object)HttpClientUtils.readResponse(result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockingSender() throws IOException {
        StringBuilder sb = new StringBuilder(10000);
        for (int i = 0; i < 10000; ++i) {
            sb.append("a");
        }
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/?blocking=true");
        TestHttpClient client = new TestHttpClient();
        try {
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)sb.toString(), (Object)HttpClientUtils.readResponse(result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

