/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.test.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.NameVirtualHostHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.SetHeaderHandler;
import io.undertow.test.utils.DefaultServer;
import io.undertow.test.utils.HttpClientUtils;
import io.undertow.util.TestHttpClient;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class VirtualHostTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVirtualHost() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            NameVirtualHostHandler handler = new NameVirtualHostHandler().addHost("localhost", (HttpHandler)new SetHeaderHandler((HttpHandler)ResponseCodeHandler.HANDLE_200, "myHost", "localhost")).setDefaultHandler((HttpHandler)new SetHeaderHandler((HttpHandler)ResponseCodeHandler.HANDLE_200, "myHost", "default"));
            DefaultServer.setRootHandler((HttpHandler)handler);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header[] header = result.getHeaders("myHost");
            Assert.assertEquals((Object)"localhost", (Object)header[0].getValue());
            HttpClientUtils.readResponse(result);
            get = new HttpGet("http://" + DefaultServer.getDefaultServerAddress().getAddress().getHostAddress() + ":" + DefaultServer.getDefaultServerAddress().getPort() + "/path");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            header = result.getHeaders("myHost");
            Assert.assertEquals((Object)"default", (Object)header[0].getValue());
            HttpClientUtils.readResponse(result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

