/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.GSSAPIServerSubjectFactory;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.GSSContextCredential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpServerConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.FlexBase64;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class GSSAPIAuthenticationMechanism
implements AuthenticationMechanism {
    private static final String NEGOTIATION_PLAIN = Headers.NEGOTIATE.toString();
    private static final String NEGOTIATE_PREFIX = Headers.NEGOTIATE + " ";
    private final String name = "SPNEGO";
    private final GSSAPIServerSubjectFactory subjectFactory;

    public GSSAPIAuthenticationMechanism(GSSAPIServerSubjectFactory subjectFactory) {
        this.subjectFactory = subjectFactory;
    }

    @Override
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        HeaderValues authHeaders;
        HttpServerConnection connection = exchange.getConnection();
        NegotiationContext negContext = connection.getAttachment(NegotiationContext.ATTACHMENT_KEY);
        if (negContext != null) {
            exchange.putAttachment(NegotiationContext.ATTACHMENT_KEY, negContext);
            if (negContext.isEstablished()) {
                IdentityManager identityManager = securityContext.getIdentityManager();
                Account account = identityManager.verify(new GSSContextCredential(negContext.getGssContext()));
                if (account != null) {
                    securityContext.authenticationComplete(account, "SPNEGO");
                    return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                }
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
        }
        if ((authHeaders = exchange.getRequestHeaders().get(Headers.AUTHORIZATION)) != null) {
            for (String current : authHeaders) {
                if (!current.startsWith(NEGOTIATE_PREFIX)) continue;
                String base64Challenge = current.substring(NEGOTIATE_PREFIX.length());
                try {
                    ByteBuffer challenge = FlexBase64.decode(base64Challenge);
                    return this.runGSSAPI(exchange, challenge, securityContext);
                }
                catch (IOException e) {
                    return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                }
            }
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    @Override
    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        NegotiationContext negContext = exchange.getAttachment(NegotiationContext.ATTACHMENT_KEY);
        String header = NEGOTIATION_PLAIN;
        if (negContext != null) {
            byte[] responseChallenge = negContext.useResponseToken();
            exchange.putAttachment(NegotiationContext.ATTACHMENT_KEY, null);
            if (responseChallenge != null) {
                header = NEGOTIATE_PREFIX + FlexBase64.encodeString(responseChallenge, false);
            }
        }
        exchange.getResponseHeaders().add(Headers.WWW_AUTHENTICATE, header);
        return new AuthenticationMechanism.ChallengeResult(true, 401);
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome runGSSAPI(HttpServerExchange exchange, ByteBuffer challenge, SecurityContext securityContext) {
        try {
            Subject server = this.subjectFactory.getSubjectForHost(this.getHostName(exchange));
            return Subject.doAs(server, new AcceptSecurityContext(exchange, challenge, securityContext));
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
    }

    private String getHostName(HttpServerExchange exchange) {
        String hostName = exchange.getRequestHeaders().getFirst(Headers.HOST);
        if (hostName != null) {
            if (hostName.contains(":")) {
                hostName = hostName.substring(0, hostName.indexOf(":"));
            }
            return hostName;
        }
        return null;
    }

    private static class NegotiationContext {
        static final AttachmentKey<NegotiationContext> ATTACHMENT_KEY = AttachmentKey.create(NegotiationContext.class);
        private GSSContext gssContext;
        private byte[] responseToken;
        private Principal principal;

        private NegotiationContext() {
        }

        GSSContext getGssContext() {
            return this.gssContext;
        }

        void setGssContext(GSSContext gssContext) {
            this.gssContext = gssContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        byte[] useResponseToken() {
            try {
                byte[] byArray = this.responseToken;
                return byArray;
            }
            finally {
                this.responseToken = null;
            }
        }

        void setResponseToken(byte[] responseToken) {
            this.responseToken = responseToken;
        }

        boolean isEstablished() {
            return this.gssContext != null ? this.gssContext.isEstablished() : false;
        }

        Principal getPrincipal() {
            if (!this.isEstablished()) {
                throw new IllegalStateException("No established GSSContext to use for the Principal.");
            }
            if (this.principal == null) {
                try {
                    this.principal = new KerberosPrincipal(this.gssContext.getSrcName().toString());
                }
                catch (GSSException e) {
                    throw new IllegalStateException("Unable to create Principal", e);
                }
            }
            return this.principal;
        }
    }

    private class AcceptSecurityContext
    implements PrivilegedExceptionAction<AuthenticationMechanism.AuthenticationMechanismOutcome> {
        private final HttpServerExchange exchange;
        private final ByteBuffer challenge;
        private final SecurityContext securityContext;

        private AcceptSecurityContext(HttpServerExchange exchange, ByteBuffer challenge, SecurityContext securityContext) {
            this.exchange = exchange;
            this.challenge = challenge;
            this.securityContext = securityContext;
        }

        @Override
        public AuthenticationMechanism.AuthenticationMechanismOutcome run() throws GSSException {
            GSSContext gssContext;
            NegotiationContext negContext = this.exchange.getAttachment(NegotiationContext.ATTACHMENT_KEY);
            if (negContext == null) {
                negContext = new NegotiationContext();
                this.exchange.putAttachment(NegotiationContext.ATTACHMENT_KEY, negContext);
                this.exchange.getConnection().putAttachment(NegotiationContext.ATTACHMENT_KEY, negContext);
            }
            if ((gssContext = negContext.getGssContext()) == null) {
                GSSManager manager = GSSManager.getInstance();
                gssContext = manager.createContext((GSSCredential)null);
                negContext.setGssContext(gssContext);
            }
            byte[] respToken = gssContext.acceptSecContext(this.challenge.array(), this.challenge.arrayOffset(), this.challenge.limit());
            negContext.setResponseToken(respToken);
            if (negContext.isEstablished()) {
                IdentityManager identityManager;
                Account account;
                if (respToken != null) {
                    this.exchange.getResponseHeaders().add(Headers.WWW_AUTHENTICATE, NEGOTIATE_PREFIX + FlexBase64.encodeString(respToken, false));
                }
                if ((account = (identityManager = this.securityContext.getIdentityManager()).verify(new GSSContextCredential(negContext.getGssContext()))) != null) {
                    this.securityContext.authenticationComplete(account, "SPNEGO");
                    return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                }
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
    }
}

