/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.HttpContinueHandler;
import io.undertow.testutils.AjpIgnore;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
@AjpIgnore
public class HttpContinueTestCase {
    private static volatile boolean accept = false;

    @BeforeClass
    public static void setup() {
        BlockingHandler blockingHandler = new BlockingHandler();
        HttpContinueHandler handler = new HttpContinueHandler((HttpHandler)blockingHandler){

            protected boolean acceptRequest(HttpServerExchange exchange) {
                return accept;
            }
        };
        DefaultServer.setRootHandler((HttpHandler)handler);
        blockingHandler.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                try {
                    byte[] buffer = new byte[1024];
                    ByteArrayOutputStream b = new ByteArrayOutputStream();
                    int r = 0;
                    OutputStream outputStream = exchange.getOutputStream();
                    InputStream inputStream = exchange.getInputStream();
                    while ((r = inputStream.read(buffer)) > 0) {
                        b.write(buffer, 0, r);
                    }
                    outputStream.write(b.toByteArray());
                    outputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpContinueRejected() throws IOException {
        accept = false;
        String message = "My HTTP Request!";
        BasicHttpParams httpParams = new BasicHttpParams();
        httpParams.setParameter("http.protocol.wait-for-continue", (Object)Integer.MAX_VALUE);
        TestHttpClient client = new TestHttpClient();
        client.setParams((HttpParams)httpParams);
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/path");
            post.addHeader("Expect", "100-continue");
            post.setEntity((HttpEntity)new StringEntity(message));
            HttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)417L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpContinueAccepted() throws IOException {
        accept = true;
        String message = "My HTTP Request!";
        BasicHttpParams httpParams = new BasicHttpParams();
        httpParams.setParameter("http.protocol.wait-for-continue", (Object)Integer.MAX_VALUE);
        TestHttpClient client = new TestHttpClient();
        client.setParams((HttpParams)httpParams);
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/path");
            post.addHeader("Expect", "100-continue");
            post.setEntity((HttpEntity)new StringEntity(message));
            HttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)message, (Object)HttpClientUtils.readResponse(result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

